/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.ant.WsdlBasedAntTaskArguments;
import oracle.eclipse.tools.webservices.model.LightweightWsdlModel;
import oracle.eclipse.tools.webservices.ui.wizards.AntWrapperWizard;
import oracle.eclipse.tools.webservices.ui.wizards.WsdlModelFactory;
import oracle.eclipse.tools.webservices.ui.wizards.clientgen.WebServiceProjectWsdlLocatorContentProvider;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileSelectionChangedListener;
import oracle.eclipse.tools.webservices.ui.wizards.common.WsdlLocationPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public abstract class WsdlBasedAntWizard<T extends WsdlBasedAntTaskArguments>
extends AntWrapperWizard {
    private final T arguments;
    private WsdlLocationPage wsdlPage;
    private boolean initialized = false;
    private String helpContextId;

    public WsdlBasedAntWizard(String wizardTitle, String processTitle, T args, String helpContextId) {
        super(wizardTitle, processTitle);
        this.arguments = args;
        this.helpContextId = helpContextId;
    }

    public void addPages() {
        this.wsdlPage = this.createWsdlLocationPage((WsdlBasedAntTaskArguments)this.arguments, this.helpContextId);
        this.addPage((IWizardPage)this.wsdlPage);
    }

    public boolean updateModel(LightweightWsdlModel model) {
        if (model == null || !this.validateModel(model)) {
            return false;
        }
        LightweightWsdlModel oldModel = this.arguments.getWsdlModel();
        if (oldModel != model) {
            this.arguments.setWsdlModel(model);
            if (this.initialized) {
                this.updatePages();
            }
        }
        return true;
    }

    public boolean validateModel(LightweightWsdlModel model) {
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.arguments.getWsdlModel() != null) {
            this.updatePages();
        }
        IWorkbenchHelpSystem help = PlatformUI.getWorkbench().getHelpSystem();
        help.setHelp((Control)this.getShell(), this.helpContextId);
        this.initialized = true;
    }

    public T getArguments() {
        return this.arguments;
    }

    protected WsdlLocationPage createWsdlLocationPage(WsdlBasedAntTaskArguments args, String helpContextId) {
        return new WsdlLocationPage(args, new WebServiceProjectWsdlLocatorContentProvider(), this.getWsdlSelectionChangedListener(), helpContextId);
    }

    protected IFileSelectionChangedListener getWsdlSelectionChangedListener() {
        return new WsdlSelectionChangedListenerImpl();
    }

    protected WsdlLocationPage getWsdlPage() {
        return this.wsdlPage;
    }

    public class WsdlSelectionChangedListenerImpl
    implements IFileSelectionChangedListener {
        @Override
        public boolean fileSelectionChanged(IStructuredSelection selection, IFile wsdl) {
            if (wsdl == null) {
                return false;
            }
            IProject project = wsdl.getProject();
            assert (WebServiceProject.isWebServiceProject((IProject)project)) : "Not allowing wsdl selection for non-webservice project";
            LightweightWsdlModel model = WsdlModelFactory.createModel((IRunnableContext)WsdlBasedAntWizard.this.getContainer(), wsdl);
            return WsdlBasedAntWizard.this.updateModel(model);
        }
    }
}

