/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.JAXVersion;
import oracle.eclipse.tools.webservices.features.WebServiceFacetProjectCreationDataModelProvider;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebServiceProjectWizard
extends WebProjectWizard {
    public WebServiceProjectWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(Messages.webservice_project_wizard_window_title);
    }

    public WebServiceProjectWizard() {
        this.setWindowTitle(Messages.webservice_project_wizard_window_title);
    }

    protected ImageDescriptor getDefaultPageImageDescriptor() {
        return WebServicesUIPlugin.Images.WEB_PROJ_WIZ.getImageDescriptor();
    }

    protected IWizardPage createFirstPage() {
        WebServicesFirstPage firstPage = new WebServicesFirstPage(this.model);
        firstPage.setDescription(Messages.webservice_project_wizard_page_description);
        firstPage.setTitle(Messages.webservice_project_wizard_page_title);
        return firstPage;
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"template.wls.webservices");
    }

    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(Messages.webservice_project_wizard_page_title);
        super.performFinish(monitor);
        this.getFacetedProject().getProject().refreshLocal(2, monitor);
    }

    protected IDataModel createDataModel() {
        try {
            return DataModelFactory.createDataModel((IDataModelProvider)new WebServiceFacetProjectCreationDataModelProvider());
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    private class WebServicesFirstPage
    extends WebProjectFirstPage {
        private WebServicesFirstPage(IDataModel model) {
            super(model, Messages.webservice_project_wizard_page_title);
            this.setImageDescriptor(WebServiceProjectWizard.this.getDefaultPageImageDescriptor());
        }

        public boolean isPageComplete() {
            String name = this.projectNameGroup.projectNameField.getText();
            if (!name.matches(".*[\\s!@#$%^&*(),.<>\"'~`?;:\\+{}\\[\\]]+.*")) {
                return super.isPageComplete();
            }
            this.setErrorMessage(Messages.incorrect_characters);
            return false;
        }

        protected String getModuleFacetID() {
            return JAXVersion.ORACLE_WEBLOGIC_WEB_SERVICE_FEATURE.getId();
        }
    }
}

