/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import com.bea.wlw.template.ITemplateBean;
import com.bea.wlw.template.exceptions.GenerationFailedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.common.templating.filetemplate.FormattingService;
import oracle.eclipse.tools.common.templating.template.core.TemplateService;
import oracle.eclipse.tools.common.ui.wizards.AbstractContainerSelectionGroup;
import oracle.eclipse.tools.common.ui.wizards.ContainerContentProviderForJava;
import oracle.eclipse.tools.common.ui.wizards.NewFileWizardPage;
import oracle.eclipse.tools.common.ui.wizards.ResourceAndContainerGroup;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.FolderUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServiceProject;
import oracle.eclipse.tools.webservices.template.WebServiceTemplateBean;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.NewClassContainerSelectionGroup;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class NewWebServiceFileWizardPage
extends NewFileWizardPage {
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.webservices.ui.NewWebLogicWebServiceWizard";
    private String warningMsg = null;
    private WebServiceTemplateBean bean;
    private Button _mtomButton;
    private Button _seiButton;

    public NewWebServiceFileWizardPage(String pageName, IStructuredSelection selection, WebServiceTemplateBean bean) {
        super(pageName, selection, HELP_CONTEXT_ID);
        this.bean = bean;
    }

    protected boolean allowLinking() {
        return false;
    }

    public IFile createNewFile() {
        IFile file = this.getFile();
        this.bean.setPackageName(NewWebServiceFileWizardPage.getPackageName(file.getParent()));
        this.bean.setClassName(file.getFullPath().removeFileExtension().lastSegment());
        this.bean.setEndpointInterface(this._seiButton.getSelection());
        this.bean.setMtom(this._mtomButton.getSelection());
        try {
            if (!this._seiButton.getSelection()) {
                this.generateTemplateFile(file, this.bean, "oracle.eclipse.tools.webservices.filetemplate.newWebService", true);
            } else {
                this.generateTemplateFile(file, this.bean, "oracle.eclipse.tools.webservices.filetemplate.newSEIWebService", true);
                file = this.getImplFile();
                this.generateTemplateFile(file, this.bean, "oracle.eclipse.tools.webservices.filetemplate.newWebService", true);
            }
            return file;
        }
        catch (UnsupportedEncodingException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (GenerationFailedException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
        return null;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.isContentProviderEmpty()) {
            this.setErrorMessage(WebServicesUIMessages.getString("no-web-services-project-msg"));
        }
    }

    public String getImplFileName() {
        String result = super.getFileName();
        if (result.indexOf(46) < 0) {
            result = String.valueOf(result) + "Impl";
            result = String.valueOf(result) + "." + this.getDefaultFileExtension();
        } else {
            StringBuffer bufferResult = new StringBuffer(result);
            result = bufferResult.insert(result.indexOf(46), "Impl").toString();
        }
        return result;
    }

    public IFile getImplFile() {
        IPath containerFilePath = this.getContainerFullPath();
        if (containerFilePath == null) {
            return null;
        }
        IPath filePath = containerFilePath.append(this.getImplFileName());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        return file;
    }

    protected ITreeContentProvider createContainerContentProvider() {
        return new ContainerContentProviderForJava(){

            protected boolean isValidProject(IProject project) {
                return WebServiceProject.isWebServiceProject((IProject)project);
            }
        };
    }

    protected boolean validatePage() {
        this.warningMsg = null;
        boolean ret = super.validatePage();
        if (ret && this.warningMsg != null) {
            this.setMessage(this.warningMsg, 2);
        }
        return ret;
    }

    protected String getDefaultFileExtension() {
        return "java";
    }

    protected boolean validateFile(IFile file) {
        IContainer pkgContainer = file.getParent();
        String pkgName = NewWebServiceFileWizardPage.getPackageName(pkgContainer);
        if (pkgName == null) {
            this.setErrorMessage(WebServicesUIMessages.getString("NewWebServiceFileWizardPage.error.notPackage"));
            return false;
        }
        if (pkgName.equals("")) {
            this.setErrorMessage(WebServicesUIMessages.getString("NewWebServiceFileWizardPage.error.defaultPackage"));
            return false;
        }
        if (pkgContainer instanceof IFolder && !FolderUtil.validFolderPathVariant((IFolder)((IFolder)pkgContainer))) {
            this.setErrorMessage(WebServicesUIMessages.getString("NewWebServiceFileWizardPage.error.packageCaseVariantExists"));
            return false;
        }
        if (!this.hasValidExtension(file)) {
            this.setErrorMessage(WebServicesUIMessages.getFormattedString("NewWebServiceFileWizardPage.error.fileNameExtension", this.getDefaultFileExtension()));
            return false;
        }
        StringBuffer message = new StringBuffer();
        String name = file.getName();
        if (!StringUtil.validateJavaIdentifier((String)(name = name.substring(0, name.length() - (file.getFileExtension().length() + 1))), (StringBuffer)message)) {
            this.setErrorMessage(message.toString());
            return false;
        }
        if (Character.isLowerCase(name.charAt(0))) {
            this.warningMsg = WebServicesUIMessages.getString("NewWebServiceFileWizardPage.warning.lowerCaseFirstChar");
        }
        if (!EclipseFileUtil.caseSensitiveDoesNotExist((IFile)file)) {
            this.setErrorMessage(WebServicesUIMessages.getString("NewWebServiceFileWizardPage.error.caseInsensitiveTypeExists"));
            return false;
        }
        return true;
    }

    protected ResourceAndContainerGroup createContainerGroup(Composite parent, Listener client, String resourceFieldLabel, String resourceType, ITreeContentProvider containerContentProvider, int heightHint) {
        return new ResourceAndContainerGroup(parent, client, resourceFieldLabel, resourceType, containerContentProvider, heightHint){
            private NewClassContainerSelectionGroup container;

            protected Label createResourceNameLabel(Composite parent, int style, String labelText, Font font) {
                return this.container.getNameLabel();
            }

            protected Text createResourceNameField(Composite parent, int style, Font font) {
                return this.container.getNameField();
            }

            protected AbstractContainerSelectionGroup createContainerGroup(Composite composite, int heightHint) {
                this.container = new NewClassContainerSelectionGroup(composite);
                return this.container;
            }
        };
    }

    protected void createAdvancedControls(Composite parent) {
        super.createAdvancedControls(parent);
        this._mtomButton = new Button(parent, 32);
        this._mtomButton.setFont(parent.getFont());
        this._mtomButton.setText(WebServicesUIMessages.getString("NewWebServiceFileWizardPage.enableMTOM"));
        this._mtomButton.setToolTipText(WebServicesUIMessages.getString("NewWebServiceFileWizardPage.descriptionMTOM"));
        GridData data = this.setButtonLayoutData(this._mtomButton);
        data.horizontalAlignment = 1;
        this._mtomButton.setLayoutData((Object)data);
        this._seiButton = new Button(parent, 32);
        this._seiButton.setFont(parent.getFont());
        this._seiButton.setText(WebServicesUIMessages.getString("NewWebServiceFileWizardPage.generateSEI"));
        data = this.setButtonLayoutData(this._seiButton);
        data.horizontalAlignment = 1;
        this._seiButton.setLayoutData((Object)data);
    }

    private static String getPackageName(IContainer container) {
        IJavaElement elem = JavaCore.create((IResource)container);
        if (elem instanceof IPackageFragmentRoot) {
            return "";
        }
        if (elem instanceof IPackageFragment) {
            return ((IPackageFragment)elem).getElementName();
        }
        return null;
    }

    private void generateTemplateFile(IFile file, WebServiceTemplateBean bean, String templateID, boolean force) throws GenerationFailedException, UnsupportedEncodingException, CoreException {
        String fileContents = TemplateService.generate((String)templateID, (ITemplateBean)bean);
        fileContents = FormattingService.formatSource((IProject)file.getProject(), (IPath)file.getLocation(), (String)fileContents);
        IProgressMonitor progressMonitor = null;
        ByteArrayInputStream stream = new ByteArrayInputStream(fileContents.getBytes(StandardCharsets.UTF_8));
        FolderUtil.ensureFolder((IFile)file, (boolean)false, progressMonitor);
        file.create((InputStream)stream, force, progressMonitor);
    }
}

