/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.wizards.AbstractContainerSelectionGroup;
import oracle.eclipse.tools.common.ui.wizards.model.ContainerSelectionModel;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.ContainerSelectionHelper;
import oracle.eclipse.tools.webservices.ui.wizards.jws.model.JWSContainerSelectionModel;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class NewClassContainerSelectionGroup
extends AbstractContainerSelectionGroup {
    private Label resourceLabel;
    private Text sourceText;
    private Text packageText;
    private Text resourceText;
    private Button sourceButton;
    private Button packageButton;
    private JWSContainerSelectionModel model;

    public NewClassContainerSelectionGroup(Composite parent) {
        super(parent);
        this.doLayout();
        this.addListeners();
    }

    protected ContainerSelectionModel createModel() {
        if (this.model == null) {
            this.model = new JWSContainerSelectionModel();
        }
        return this.model;
    }

    private void doLayout() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        GridData horizontalFillData = new GridData();
        horizontalFillData.grabExcessHorizontalSpace = true;
        horizontalFillData.horizontalAlignment = 4;
        this.setLayoutData(horizontalFillData);
        Composite container = new Composite((Composite)this, 0);
        GridLayout containerGridLayout = new GridLayout(3, false);
        containerGridLayout.marginHeight = 0;
        containerGridLayout.marginWidth = 0;
        container.setLayout((Layout)containerGridLayout);
        container.setLayoutData((Object)horizontalFillData);
        Label sourceLabel = new Label(container, 0);
        sourceLabel.setText(WebServicesUIMessages.getString("NewClassContainerSelectionGroup.sourcePath"));
        this.sourceText = new Text(container, 2052);
        this.sourceText.setLayoutData((Object)horizontalFillData);
        this.sourceButton = new Button(container, 0);
        this.sourceButton.setImage(WebServicesUIPlugin.Images.BROWSE.getImage());
        Label packageLabel = new Label(container, 0);
        packageLabel.setText(WebServicesUIMessages.getString("NewClassContainerSelectionGroup.package"));
        this.packageText = new Text(container, 2052);
        this.packageText.setLayoutData((Object)horizontalFillData);
        this.addPackageFieldAssist(this.packageText);
        this.packageButton = new Button(container, 0);
        this.packageButton.setImage(WebServicesUIPlugin.Images.BROWSE.getImage());
        GridData lineFillData = new GridData();
        lineFillData.horizontalSpan = 3;
        lineFillData.verticalIndent = 5;
        lineFillData.grabExcessHorizontalSpace = true;
        lineFillData.horizontalAlignment = 4;
        Label label = new Label(container, 258);
        label.setLayoutData((Object)lineFillData);
        this.resourceLabel = new Label(container, 0);
        this.resourceLabel.setText(WebServicesUIMessages.getString("NewClassContainerSelectionGroup.resourceLabelText"));
        this.resourceText = new Text(container, 2052);
        this.resourceText.setLayoutData((Object)horizontalFillData);
    }

    protected Label getNameLabel() {
        return this.resourceLabel;
    }

    protected Text getNameField() {
        return this.resourceText;
    }

    private void addListeners() {
        this.sourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewClassContainerSelectionGroup.this.model.setPackageRoot(NewClassContainerSelectionGroup.this.sourceText.getText());
            }
        });
        this.sourceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IPackageFragmentRoot chosenSourceFolder = ContainerSelectionHelper.choosePackageRoot(NewClassContainerSelectionGroup.this.getShell(), (IJavaElement)NewClassContainerSelectionGroup.this.model.getPackageRootElement());
                if (chosenSourceFolder != null) {
                    NewClassContainerSelectionGroup.this.model.setPackageRoot(chosenSourceFolder);
                }
            }
        });
        this.packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewClassContainerSelectionGroup.this.model.setPackage(NewClassContainerSelectionGroup.this.packageText.getText());
            }
        });
        this.packageButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IPackageFragment chosenPackage = ContainerSelectionHelper.choosePackage(NewClassContainerSelectionGroup.this.getShell(), NewClassContainerSelectionGroup.this.model.getPackageRootElement(), NewClassContainerSelectionGroup.this.model.getPackageElement());
                if (chosenPackage != null) {
                    NewClassContainerSelectionGroup.this.model.setPackage(chosenPackage);
                }
            }
        });
        this.model.addPropertyChangeListener("PACKAGE_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewClassContainerSelectionGroup.this.updateText(NewClassContainerSelectionGroup.this.packageText, NewClassContainerSelectionGroup.this.model.getPackage());
            }
        });
        this.model.addPropertyChangeListener("PACKAGE_ROOT_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewClassContainerSelectionGroup.this.updateText(NewClassContainerSelectionGroup.this.sourceText, NewClassContainerSelectionGroup.this.model.getPackageRoot());
            }
        });
    }

    private void addPackageFieldAssist(Text text) {
        ControlDecoration decoration = new ControlDecoration((Control)this.packageText, 16512);
        decoration.setShowOnlyOnFocus(true);
        FieldDecoration proposalIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        decoration.setImage(proposalIndicator.getImage());
        decoration.setDescriptionText(proposalIndicator.getDescription());
        IContentProposalProvider proposalProvider = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                List<IPackageFragment> packages = ContainerSelectionHelper.getPackages(NewClassContainerSelectionGroup.this.model.getPackageRootElement());
                ArrayList<JavaPackageContentProposal> proposals = new ArrayList<JavaPackageContentProposal>();
                for (IPackageFragment pkg : packages) {
                    if (!pkg.getElementName().startsWith(contents)) continue;
                    proposals.add(new JavaPackageContentProposal(pkg));
                }
                return proposals.toArray(new IContentProposal[proposals.size()]);
            }
        };
        ContentAssistCommandAdapter contentAssist = new ContentAssistCommandAdapter((Control)this.packageText, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, null, null);
        contentAssist.setProposalAcceptanceStyle(2);
        contentAssist.setLabelProvider((ILabelProvider)new JavaElementLabelProvider(){

            public Image getImage(Object element) {
                IPackageFragment pkg = ((JavaPackageContentProposal)element).getPackage();
                return super.getImage((Object)pkg);
            }

            public String getText(Object element) {
                IPackageFragment pkg = ((JavaPackageContentProposal)element).getPackage();
                return super.getText((Object)pkg);
            }
        });
    }

    private void updateText(Text text, String value) {
        if (value == null) {
            value = "";
        }
        if (!value.equals(text.getText())) {
            text.setText(value);
        }
    }

    private class JavaPackageContentProposal
    implements IContentProposal {
        private IPackageFragment pkg;

        public JavaPackageContentProposal(IPackageFragment pkg) {
            this.pkg = pkg;
        }

        public String getContent() {
            return this.pkg.getElementName();
        }

        public String getLabel() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public int getCursorPosition() {
            return this.pkg.getElementName().length();
        }

        public IPackageFragment getPackage() {
            return this.pkg;
        }
    }
}

