/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.webservices.ant.IGeneratedFilesValidator;
import oracle.eclipse.tools.webservices.ant.UnexpectedFileStateException;
import oracle.eclipse.tools.webservices.ui.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;

public final class GeneratedFilesValidator
implements IGeneratedFilesValidator {
    private final Shell shell;
    private boolean cancelled = false;

    public GeneratedFilesValidator(Shell shell) {
        this.shell = shell;
    }

    public boolean validateFiles(IProgressMonitor monitor, List<IFile> existingFiles, List<IResource> readonlyResources) throws UnexpectedFileStateException {
        StringBuilder message;
        ArrayList<IFolder> readOnlyFolders = new ArrayList<IFolder>(readonlyResources.size());
        ArrayList<IFile> readOnlyFiles = new ArrayList<IFile>(readonlyResources.size());
        if (readonlyResources.size() > 0) {
            for (IResource resource : readonlyResources) {
                if (resource.getType() == 1) {
                    readOnlyFiles.add((IFile)resource);
                    continue;
                }
                if (resource.getType() != 2) continue;
                readOnlyFolders.add((IFolder)resource);
            }
        }
        if (existingFiles.size() > 0) {
            message = new StringBuilder(Messages.generated_files_validator_overwrite_msg);
            for (IFile file : existingFiles) {
                message.append("\n  ").append(file.getFullPath().toPortableString());
            }
            this.cancelled = !DialogService.showConfirmDialog((String)Messages.generated_files_validator_overwrite, (String)message.toString());
        } else if (readOnlyFolders.size() > 0 && readOnlyFiles.size() == 0) {
            message = new StringBuilder(Messages.dest_folder_validator_writable_msg);
            for (IFolder folder : readOnlyFolders) {
                message.append("\n  ").append(folder.getFullPath().toPortableString());
            }
            boolean bl = this.cancelled = !DialogService.showConfirmDialog((String)Messages.dest_folder_validator_writable_title, (String)message.toString());
        }
        if (readOnlyFiles.size() > 0) {
            IFile[] validating = readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]);
            IStatus status = ResourcesPlugin.getWorkspace().validateEdit(validating, (Object)this.shell);
            if (status.isOK()) {
                IFile[] iFileArray = validating;
                int n = validating.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file = iFileArray[n2];
                    if (file.isReadOnly()) {
                        throw new UnexpectedFileStateException((IResource)file, UnexpectedFileStateException.FileState.WRITABLE, UnexpectedFileStateException.FileState.READ_ONLY);
                    }
                    ++n2;
                }
            } else {
                this.cancelled = true;
            }
        }
        if (this.cancelled) {
            return !this.cancelled;
        }
        if (readOnlyFolders.size() > 0) {
            this.setFolderReadOnly(readOnlyFolders, true);
        }
        return !this.cancelled;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private void setFolderReadOnly(List<IFolder> list, boolean readOnly) throws UnexpectedFileStateException {
        for (IFolder folder : list) {
            ResourceAttributes attributes = folder.getResourceAttributes();
            attributes.setReadOnly(false);
            try {
                folder.setResourceAttributes(attributes);
            }
            catch (CoreException coreException) {
                throw new UnexpectedFileStateException((IResource)folder, UnexpectedFileStateException.FileState.WRITABLE, UnexpectedFileStateException.FileState.READ_ONLY);
            }
        }
    }
}

