/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.util;

import java.util.ArrayList;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PreferencesUtil;

class RuntimeQuickFix
implements IMarkerResolution {
    private static final String TARGET_RUNTIME = "org.eclipse.wst.common.project.facet.ui.RuntimesPropertyPage";
    String label;

    RuntimeQuickFix(String label) {
        this.label = label;
    }

    public String getLabel() {
        return "Update runtime for " + this.label;
    }

    public void run(IMarker marker) {
        this.showPropertiesOn(marker.getResource().getProject(), (IProgressMonitor)new NullProgressMonitor());
    }

    private void showPropertiesOn(final IProject project, IProgressMonitor monitor) {
        Shell finalShell;
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.propertyPages").getExtensions();
        final ArrayList<String> pageIds = new ArrayList<String>(8);
        pageIds.add(TARGET_RUNTIME);
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getNamespaceIdentifier().startsWith("org.eclipse.jdt.ui.")) {
                IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configurationElements.length) {
                    if ("page".equals(configurationElements[j].getName())) {
                        pageIds.add(configurationElements[j].getAttribute("id"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        Shell shell = null;
        IWorkbenchWindow activeWorkbenchWindow = WebServicesUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            shell = activeWorkbenchWindow.getShell();
        }
        if ((finalShell = shell) != null) {
            finalShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)finalShell, (IAdaptable)project, (String)RuntimeQuickFix.TARGET_RUNTIME, (String[])pageIds.toArray(new String[pageIds.size()]), null);
                    dialog.open();
                }
            });
        }
    }
}

