/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.util;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaResourceUtil {
    private JavaResourceUtil() {
    }

    public static IPackageFragmentRoot getPackageRoot(IContainer container) {
        IJavaElement elem = JavaCore.create((IResource)container);
        if (elem instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)elem;
        }
        return null;
    }

    public static IPackageFragmentRoot getDefaultPackageRoot(IContainer container) {
        IPackageFragmentRoot packageRoot = JavaResourceUtil.findPackageRoot(container);
        if (packageRoot == null && container != null && container == container.getProject()) {
            IJavaProject javaProject = JavaCore.create((IProject)container.getProject());
            try {
                IPackageFragmentRoot[] allPackageRoots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageRoots = javaProject.getAllPackageFragmentRoots();
                int n = allPackageRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (JavaResourceUtil.valid(root)) {
                        packageRoot = root;
                        break;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return packageRoot;
    }

    public static IPackageFragmentRoot findPackageRoot(IContainer container) {
        IContainer packageRootContainer = container;
        IPackageFragmentRoot packageRoot = null;
        while (packageRootContainer != null) {
            packageRoot = JavaResourceUtil.getPackageRoot(packageRootContainer);
            if (packageRoot != null) break;
            packageRootContainer = packageRootContainer.getParent();
        }
        return packageRoot;
    }

    public static IPackageFragment getPackage(IContainer container) {
        IJavaElement elem = JavaCore.create((IResource)container);
        if (elem instanceof IPackageFragment) {
            return (IPackageFragment)elem;
        }
        return null;
    }

    public static boolean valid(IPackageFragmentRoot root) {
        try {
            return root.getKind() == 1 && !root.getResource().isDerived();
        }
        catch (JavaModelException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
            return false;
        }
    }
}

