/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.refactor.template.variables;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.variables.AnnotatedMethodResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.ClassDependentAnnotatedMethodResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.FieldDeclarationResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.LocalClassTypeResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.MethodSignatureResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.UniqueNameResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.VariableSpecifiedImportResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceMethod;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceVariableFactory;
import oracle.eclipse.tools.webservices.ui.refactor.template.variables.DependentImportResolver;
import oracle.eclipse.tools.webservices.ui.refactor.template.variables.DependentMethodReturnTypeImportResolver;
import oracle.eclipse.tools.webservices.ui.refactor.template.variables.ModelClassResolver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class RefactorResolverFactory {
    public static void createVariableResolvers(TemplateContextType context) {
        context.addResolver((TemplateVariableResolver)new ModelClassResolver(WebServiceVariableFactory.WebServiceVariableType.CLASS_TYPE));
        context.addResolver((TemplateVariableResolver)new LocalClassTypeResolver(WebServiceVariableFactory.WebServiceVariableType.LOCAL_CLASS_TYPE));
        context.addResolver((TemplateVariableResolver)new UniqueNameResolver(WebServiceVariableFactory.WebServiceVariableType.UNIQUE_NAME));
        context.addResolver((TemplateVariableResolver)new AnnotatedMethodResolver(WebServiceVariableFactory.WebServiceVariableType.ANNOTATED_METHOD){

            @Override
            public String getValue(IMethod method) {
                WebServiceMethod webServiceMethod = new WebServiceMethod(method);
                try {
                    return webServiceMethod.methodName();
                }
                catch (IllegalArgumentException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                    return null;
                }
            }
        });
        context.addResolver((TemplateVariableResolver)new MethodSignatureResolver(WebServiceVariableFactory.WebServiceVariableType.METHOD_DEPENDENT_RETURN_TYPE){

            @Override
            public String getValue(IMethod method) {
                WebServiceMethod webServiceMethod = new WebServiceMethod(method);
                try {
                    return webServiceMethod.returnType();
                }
                catch (IllegalArgumentException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                }
                return null;
            }
        });
        context.addResolver((TemplateVariableResolver)new MethodSignatureResolver(WebServiceVariableFactory.WebServiceVariableType.METHOD_DEPENDENT_PARAMETER){

            @Override
            public String getValue(IMethod method) {
                WebServiceMethod webServiceMethod = new WebServiceMethod(method);
                try {
                    return webServiceMethod.methodParameters();
                }
                catch (IllegalArgumentException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                }
                return null;
            }
        });
        context.addResolver((TemplateVariableResolver)new ClassDependentAnnotatedMethodResolver("javax.jws.WebMethod", WebServiceVariableFactory.WebServiceVariableType.CLASS_DEPENDENT_ANNOTATED_METHOD){

            @Override
            public String getValue(IMethod method) {
                WebServiceMethod webServiceMethod = new WebServiceMethod(method);
                try {
                    return webServiceMethod.methodNameParameterNames();
                }
                catch (IllegalArgumentException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                }
                return null;
            }
        });
        context.addResolver((TemplateVariableResolver)new DependentImportResolver(WebServiceVariableFactory.WebServiceVariableType.CLASS_TYPE_IMPORT));
        context.addResolver((TemplateVariableResolver)new DependentMethodReturnTypeImportResolver(WebServiceVariableFactory.WebServiceVariableType.RETURN_TYPE_IMPORT));
        context.addResolver((TemplateVariableResolver)new VariableSpecifiedImportResolver(WebServiceVariableFactory.WebServiceVariableType.SPECIFIED_IMPORT));
        context.addResolver((TemplateVariableResolver)new FieldDeclarationResolver(WebServiceVariableFactory.WebServiceVariableType.FIELD_DECLARATION));
    }
}

