/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.refactor.template;

import java.util.ArrayList;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.refactor.template.RefactorTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplateStore;

public final class RefactorTemplateProcessor {
    public static Template[] computeRefactorTemplates(RefactorTemplateContext context) {
        if (context == null) {
            return new Template[0];
        }
        Template[] templates = RefactorTemplateProcessor.getTemplates(context.getContextType().getId());
        ArrayList<Template> matches = new ArrayList<Template>();
        int i = 0;
        while (i < templates.length) {
            block5: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block5;
                }
                if (template.matches(context.getInfo().getSourceFile().getFileExtension(), context.getContextType().getId())) {
                    matches.add(template);
                }
            }
            ++i;
        }
        return matches.toArray(new Template[matches.size()]);
    }

    public static Template[] getTemplates(String contextTypeId) {
        Template[] templates = null;
        TemplateStore store = RefactorTemplateProcessor.getTemplateStore();
        if (store != null) {
            templates = store.getTemplates(contextTypeId);
        }
        return templates;
    }

    public static TemplateContextType getContextType() {
        return WebServicesUIPlugin.getDefault().getContextTypeRegistry().getContextType("refactor-web-service");
    }

    private static TemplateStore getTemplateStore() {
        return WebServicesUIPlugin.getDefault().getTemplateStore();
    }
}

