/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.refactor.template;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.refactor.template.RefactorRegion;
import org.eclipse.core.runtime.Plugin;

public class ElementRegionProvider {
    private static String defaultEncoding = new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), StandardCharsets.UTF_8).getEncoding();

    public static RefactorRegion createElementRegion(String content) throws IOException {
        return ElementRegionProvider.createElementRegion(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    public static RefactorRegion createElementRegion(InputStream inputStream) throws IOException {
        UnclosableBufferedInputStream bufferedInputStream = new UnclosableBufferedInputStream(inputStream);
        try {
            RefactorRegion region;
            RefactorRegion refactorRegion = region = ElementRegionProvider.generateMergeDocumentRegions(bufferedInputStream, defaultEncoding);
            return refactorRegion;
        }
        catch (XMLStreamException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        finally {
            bufferedInputStream.superClose();
        }
        return null;
    }

    private static RefactorRegion generateMergeDocumentRegions(InputStream content, String encoding) throws XMLStreamException {
        if (content != null) {
            try (XMLStreamReader eventReader = null;){
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                eventReader = inputFactory.createXMLStreamReader(content, encoding);
                RefactorRegion docRegion = ElementRegionProvider.createDocumentRegion();
                ElementRegionProvider.readElement(eventReader, docRegion, false);
                RefactorRegion refactorRegion = docRegion;
                return refactorRegion;
            }
        }
        return null;
    }

    private static void readElement(XMLStreamReader reader, RefactorRegion docRegion, boolean processEnd) throws XMLStreamException {
        try {
            while (reader.hasNext()) {
                int lastOffset = reader.getLocation().getCharacterOffset();
                int event = reader.next();
                if (processEnd) continue;
                switch (event) {
                    case 5: {
                        break;
                    }
                    case 1: {
                        RefactorRegion currentRegion = ElementRegionProvider.createDocumentRegion();
                        currentRegion.setOffset(lastOffset);
                        currentRegion.setLocalName(reader.getLocalName());
                        docRegion.addRegion(currentRegion);
                        ElementRegionProvider.readElement(reader, currentRegion, processEnd);
                        break;
                    }
                    case 2: {
                        docRegion.setLength(reader.getLocation().getCharacterOffset() - docRegion.getOffset());
                        return;
                    }
                    case 8: {
                        docRegion.setLength(lastOffset);
                        return;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    private static RefactorRegion createDocumentRegion() {
        return new RefactorRegion();
    }

    private static final class UnclosableBufferedInputStream
    extends BufferedInputStream {
        public UnclosableBufferedInputStream(InputStream in) {
            super(in);
            super.mark(Integer.MAX_VALUE);
        }

        @Override
        public void close() throws IOException {
            super.reset();
        }

        public void superClose() throws IOException {
            super.close();
        }
    }
}

