/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class WebParamAnnotationElement
extends AnnotationElement {
    private static final String[] MODE = new String[]{"IN", "OUT", "INOUT"};
    private static final String[] HEADER = new String[]{"true", "false"};
    private Expression name;
    private Expression partName;
    private Expression header;
    private Expression mode;
    private Expression targetNamespace;

    static {
        DEFAULT_VALUES.put(WebParamPropertyTypes.MODE, MODE[0]);
        DEFAULT_VALUES.put(WebParamPropertyTypes.HEADER, HEADER[1]);
    }

    public WebParamAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebParamPropertyTypes type = WebParamPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    this.setName(value);
                    break;
                }
                case PARTNAME: {
                    this.setPartName(value);
                    break;
                }
                case HEADER: {
                    this.setHeader(value);
                    break;
                }
                case MODE: {
                    this.setMode(value);
                    break;
                }
                case TARGETNAMESPACE: {
                    this.setTargetNamespace(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebParamPropertyTypes type = WebParamPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    return this.getName();
                }
                case PARTNAME: {
                    return this.getPartName();
                }
                case HEADER: {
                    return this.getHeader();
                }
                case MODE: {
                    return this.getMode();
                }
                case TARGETNAMESPACE: {
                    return this.getTargetNamespace();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebParam;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    public Expression getPartName() {
        return this.partName;
    }

    public void setPartName(Expression partName) {
        this.partName = partName;
    }

    public Expression getHeader() {
        return this.header;
    }

    public void setHeader(Expression header) {
        this.header = header;
    }

    public Expression getMode() {
        return this.mode;
    }

    public void setMode(Expression mode) {
        this.mode = mode;
    }

    public Expression getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Expression targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebParamPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebParamPropertyTypes.getPropertyType(id);
    }

    public static enum WebParamPropertyTypes implements IPropertyTypes
    {
        NAME("name"),
        PARTNAME("partName"),
        TARGETNAMESPACE("targetNamespace"),
        MODE("mode"),
        HEADER("header");

        private String name;

        private WebParamPropertyTypes(String name) {
            this.name = name;
        }

        public static WebParamPropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebParamPropertyTypes[] webParamPropertyTypesArray = WebParamPropertyTypes.values();
                int n = webParamPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebParamPropertyTypes temp = webParamPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

