/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class WebFaultAnnotationElement
extends AnnotationElement {
    private Expression name;
    private Expression faultBean;
    private Expression targetNamespace;

    public WebFaultAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        WebFaultPropertyTypes type = WebFaultPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    this.setName(value);
                    break;
                }
                case FAULTBEAN: {
                    this.setFaultBean(value);
                    break;
                }
                case TARGETNAMESPACE: {
                    this.setTargetNamespace(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        WebFaultPropertyTypes type = WebFaultPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case NAME: {
                    return this.getName();
                }
                case FAULTBEAN: {
                    return this.getFaultBean();
                }
                case TARGETNAMESPACE: {
                    return this.getTargetNamespace();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.WebFault;
    }

    public Expression getName() {
        return this.name;
    }

    public void setName(Expression name) {
        this.name = name;
    }

    public Expression getFaultBean() {
        return this.faultBean;
    }

    public void setFaultBean(Expression faultBean) {
        this.faultBean = faultBean;
    }

    public Expression getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Expression targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return WebFaultPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return WebFaultPropertyTypes.getPropertyType(id);
    }

    public static enum WebFaultPropertyTypes implements IPropertyTypes
    {
        NAME("name"),
        TARGETNAMESPACE("targetNamespace"),
        FAULTBEAN("faultBean");

        private String name;

        private WebFaultPropertyTypes(String name) {
            this.name = name;
        }

        public static WebFaultPropertyTypes getPropertyType(String name) {
            if (name != null) {
                WebFaultPropertyTypes[] webFaultPropertyTypesArray = WebFaultPropertyTypes.values();
                int n = webFaultPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebFaultPropertyTypes temp = webFaultPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

