/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class RequestWrapperAnnotationElement
extends AnnotationElement {
    private Expression className;
    private Expression localName;
    private Expression targetNamespace;

    public RequestWrapperAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        RequestWrapperPropertyTypes type = RequestWrapperPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case CLASSNAME: {
                    this.setClassName(value);
                    break;
                }
                case LOCALNAME: {
                    this.setLocalName(value);
                    break;
                }
                case TARGETNAMESPACE: {
                    this.setTargetNamespace(value);
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        RequestWrapperPropertyTypes type = RequestWrapperPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case CLASSNAME: {
                    return this.getClassName();
                }
                case LOCALNAME: {
                    return this.getLocalName();
                }
                case TARGETNAMESPACE: {
                    return this.getTargetNamespace();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.RequestWrapper;
    }

    public Expression getClassName() {
        return this.className;
    }

    public void setClassName(Expression className) {
        this.className = className;
    }

    public Expression getLocalName() {
        return this.localName;
    }

    public void setLocalName(Expression localName) {
        this.localName = localName;
    }

    public Expression getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(Expression targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return RequestWrapperPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return RequestWrapperPropertyTypes.getPropertyType(id);
    }

    public static enum RequestWrapperPropertyTypes implements IPropertyTypes
    {
        LOCALNAME("localName"),
        TARGETNAMESPACE("targetNamespace"),
        CLASSNAME("className");

        private String name;

        private RequestWrapperPropertyTypes(String name) {
            this.name = name;
        }

        public static RequestWrapperPropertyTypes getPropertyType(String name) {
            if (name != null) {
                RequestWrapperPropertyTypes[] requestWrapperPropertyTypesArray = RequestWrapperPropertyTypes.values();
                int n = requestWrapperPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RequestWrapperPropertyTypes temp = requestWrapperPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

