/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.IAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.PolicyAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public class PolicyAnnotationElement
extends AnnotationElement {
    private Expression uri;
    private Expression attachToWsdl;
    private Expression direction;

    public PolicyAnnotationElement(JavaElement parent) {
        super(parent);
    }

    public Expression getUri() {
        return this.uri;
    }

    public void setUri(Expression uri) {
        this.uri = uri;
    }

    public Expression getAttachToWsdl() {
        return this.attachToWsdl;
    }

    public void setAttachToWsdl(Expression attachToWsdl) {
        this.attachToWsdl = attachToWsdl;
    }

    public Expression getDirection() {
        return this.direction;
    }

    public void setDirection(Expression direction) {
        this.direction = direction;
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        PolicyPropertyTypes type = PolicyPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case URI: {
                    this.setUri(value);
                    break;
                }
                case ATTACHTOWSDL: {
                    this.setAttachToWsdl(value);
                    break;
                }
                case DIRECTION: {
                    this.setDirection(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        PolicyPropertyTypes type = PolicyPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case URI: {
                    return this.getUri();
                }
                case ATTACHTOWSDL: {
                    return this.getAttachToWsdl();
                }
                case DIRECTION: {
                    return this.getDirection();
                }
            }
        }
        return null;
    }

    @Override
    public IAnnotationType getAnnotationType() {
        return PolicyAnnotationType.Policy;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return PolicyPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return PolicyPropertyTypes.getPropertyType(id);
    }

    public static enum PolicyPropertyTypes implements IPropertyTypes
    {
        URI("uri"),
        ATTACHTOWSDL("attachToWsdl"),
        DIRECTION("direction");

        private String name;

        private PolicyPropertyTypes(String name) {
            this.name = name;
        }

        public static PolicyPropertyTypes getPropertyType(String name) {
            if (name != null) {
                PolicyPropertyTypes[] policyPropertyTypesArray = PolicyPropertyTypes.values();
                int n = policyPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PolicyPropertyTypes temp = policyPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

