/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.PolicyAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.context.AnnotationVisitor;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.PolicyAnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.PolicyArrayAnnotationElement;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;

public final class PoliciesAnnotationElement
extends AnnotationElement {
    private Expression value;
    private PolicyArrayAnnotationElement currentElem;
    private List<PolicyAnnotationElement> annotations = new ArrayList<PolicyAnnotationElement>();

    public PoliciesAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    public PolicyAnnotationType getAnnotationType() {
        return PolicyAnnotationType.Policies;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        if (value instanceof ArrayInitializer) {
            this.setChildElementList((ArrayInitializer)value);
        } else {
            this.annotations.clear();
        }
        this.value = value;
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return PoliciesPropertyTypes.getPropertyType(id);
    }

    @Override
    public void addAnnotation(String identifier, Map<String, String> attrs) {
        if (this.getNode() == null && this.getJavaElement().getASTNode() instanceof BodyDeclaration) {
            String arrayName = PoliciesPropertyTypes.VALUE.getIdentifier();
            String annotationName = PolicyAnnotationType.Policy.getFullyQualifiedName();
            this.getJavaElement().getWebServicePropertyData().addAnnotationWithArrayMember((BodyDeclaration)this.getJavaElement().getASTNode(), identifier, arrayName, annotationName, attrs);
        }
    }

    @Override
    public AnnotationElement addChildElement(String identifier, Map<String, String> attrs) {
        if (PolicyAnnotationType.Policy.getLabel().equals(identifier)) {
            if (this.isSet()) {
                String arrayName = PoliciesPropertyTypes.VALUE.getIdentifier();
                String annotationName = PolicyAnnotationType.Policy.getFullyQualifiedName();
                this.getJavaElement().getWebServicePropertyData().addAnnotationArrayMember(this.getNode(), arrayName, annotationName, attrs);
                return this.currentElem;
            }
            this.setAnnotation();
            return this.currentElem;
        }
        return null;
    }

    @Override
    public Object[] getChildren(Object o) {
        return this.getAnnotations().toArray(new PolicyArrayAnnotationElement[this.annotations.size()]);
    }

    @Override
    protected void createElement() {
        this.setNode(null);
        if (this.getParentNode() != null) {
            this.getParentNode().accept((ASTVisitor)new AnnotationVisitor(this, this.getJavaElement()));
        }
        if (!this.isAnnotationSet() && this.annotations != null) {
            this.annotations.clear();
        }
    }

    @Override
    protected void updateChildren() {
        for (PolicyAnnotationElement element : this.annotations) {
            element.update();
        }
    }

    @Override
    protected void refreshChildren() {
        for (PolicyAnnotationElement element : this.annotations) {
            element.refresh();
        }
    }

    public Collection<PolicyAnnotationElement> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean contains(String name) {
        for (AnnotationElement annotationElement : this.annotations) {
            if (!annotationElement.isEqual(name)) continue;
            return true;
        }
        return false;
    }

    private void setChildElementList(ArrayInitializer annotationArray) {
        if (annotationArray != null) {
            List expressions = annotationArray.expressions();
            Iterator expItr = expressions.iterator();
            ArrayList<PolicyAnnotationElement> toRemove = new ArrayList<PolicyAnnotationElement>();
            for (PolicyAnnotationElement elem : this.annotations) {
                elem.setNode(null);
                if (!elem.isRemoveAsChild()) continue;
                toRemove.add(elem);
            }
            for (PolicyAnnotationElement elem : toRemove) {
                this.annotations.remove(elem);
            }
            int i = 0;
            while (expItr.hasNext()) {
                Object expression = expItr.next();
                if (expression instanceof Annotation) {
                    if (this.annotations.size() > i) {
                        PolicyAnnotationElement elem = this.annotations.get(i);
                        elem.setNode((Annotation)expression);
                    } else {
                        this.currentElem = new PolicyArrayAnnotationElement(this.getJavaElement());
                        this.currentElem.setNode((Annotation)expression);
                        this.annotations.add(this.currentElem);
                    }
                }
                ++i;
            }
            while (expressions.size() < this.annotations.size()) {
                this.annotations.remove(this.annotations.size() - 1);
            }
        } else {
            this.annotations.clear();
        }
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        PoliciesPropertyTypes type = PoliciesPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    this.setValue(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        PoliciesPropertyTypes type = PoliciesPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    return this.getValue();
                }
            }
        }
        return null;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return PoliciesPropertyTypes.values();
    }

    public static enum PoliciesPropertyTypes implements IPropertyTypes
    {
        VALUE("value");

        private String name;

        private PoliciesPropertyTypes(String name) {
            this.name = name;
        }

        public static PoliciesPropertyTypes getPropertyType(String name) {
            if (name != null) {
                PoliciesPropertyTypes[] policiesPropertyTypesArray = PoliciesPropertyTypes.values();
                int n = policiesPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PoliciesPropertyTypes temp = policiesPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

