/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.context.WebServicePropertyContentProvider;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class JavaElement
implements IStructuredSelection {
    private final WebServicePropertyContentProvider webServicePropertyData;
    private final List<AnnotationElement> annotations = new ArrayList<AnnotationElement>();
    private ASTNode astNode;

    public JavaElement(WebServicePropertyContentProvider webServicePropertyData) {
        this.webServicePropertyData = webServicePropertyData;
    }

    protected abstract void generateAnnotationElements();

    public List<AnnotationElement> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotationElement(AnnotationElement e) {
        this.annotations.add(e);
    }

    public void removeAnnotationElement(AnnotationType type) {
        AnnotationElement ae = this.getAnnotation(type);
        if (ae != null) {
            this.annotations.remove(ae);
        }
    }

    public AnnotationElement getAnnotation(AnnotationType type) {
        for (AnnotationElement element : this.annotations) {
            if (!element.getAnnotationType().equals(type)) continue;
            return element;
        }
        return null;
    }

    public void refresh(ASTNode node) {
        if (this.isElementTypeNode(node)) {
            this.astNode = node;
            for (AnnotationElement element : this.annotations) {
                element.refresh();
            }
        }
    }

    public void update(ASTNode node) {
        if (this.isElementTypeNode(node)) {
            this.astNode = node;
            for (AnnotationElement element : this.annotations) {
                element.update();
            }
        }
    }

    public WebServicePropertyContentProvider getWebServicePropertyData() {
        return this.webServicePropertyData;
    }

    public ASTNode getASTNode() {
        return this.astNode;
    }

    public boolean isEmpty() {
        return this.annotations == null || this.annotations.size() == 0;
    }

    public Object getFirstElement() {
        return this.isEmpty() ? null : this.annotations.get(0);
    }

    public Iterator iterator() {
        return this.annotations.iterator();
    }

    public int size() {
        return this.annotations == null ? 0 : this.annotations.size();
    }

    public Object[] toArray() {
        return this.annotations == null ? new Object[]{} : this.annotations.toArray(new AnnotationElement[this.annotations.size()]);
    }

    public List toList() {
        return this.annotations;
    }

    public abstract JavaElementType getType();

    public abstract boolean isElementTypeNode(ASTNode var1);

    public IJavaProject getJavaProject() {
        if (this.webServicePropertyData.getIcompilationUnit() != null) {
            return this.webServicePropertyData.getIcompilationUnit().getJavaProject();
        }
        return null;
    }

    public IResource getResource() {
        if (this.webServicePropertyData.getIcompilationUnit() != null) {
            return this.webServicePropertyData.getIcompilationUnit().getResource();
        }
        return null;
    }

    public static enum JavaElementType {
        FIELD("field"),
        CLASS("class"),
        METHOD("method"),
        METHODPARAMETER("methodParameter");

        private String identifier;

        private JavaElementType(String identifier) {
            this.identifier = identifier;
        }

        public static JavaElementType getJavaElementType(String identifier) {
            if (identifier != null) {
                JavaElementType[] javaElementTypeArray = JavaElementType.values();
                int n = javaElementTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JavaElementType temp = javaElementTypeArray[n2];
                    if (temp.getIdentifier().equals(identifier)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

