/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class HandlerChainAnnotationElement
extends AnnotationElement {
    private Expression file;

    public HandlerChainAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        HandlerChainPropertyTypes type = HandlerChainPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case FILE: {
                    this.setFile(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        HandlerChainPropertyTypes type = HandlerChainPropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case FILE: {
                    return this.getFile();
                }
            }
        }
        return null;
    }

    @Override
    public AnnotationType getAnnotationType() {
        return AnnotationType.HandlerChain;
    }

    public Expression getFile() {
        return this.file;
    }

    public void setFile(Expression file) {
        this.file = file;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return HandlerChainPropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return HandlerChainPropertyTypes.getPropertyType(id);
    }

    public static enum HandlerChainPropertyTypes implements IPropertyTypes
    {
        FILE("file");

        private String name;

        private HandlerChainPropertyTypes(String name) {
            this.name = name;
        }

        public static HandlerChainPropertyTypes getPropertyType(String name) {
            if (name != null) {
                HandlerChainPropertyTypes[] handlerChainPropertyTypesArray = HandlerChainPropertyTypes.values();
                int n = handlerChainPropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HandlerChainPropertyTypes temp = handlerChainPropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(name)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.name;
        }
    }
}

