/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.elements;

import javax.xml.ws.http.HTTPBinding;
import javax.xml.ws.soap.SOAPBinding;
import oracle.eclipse.tools.webservices.ui.properties.jws.AnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IAnnotationType;
import oracle.eclipse.tools.webservices.ui.properties.jws.IPropertyTypes;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import org.eclipse.jdt.core.dom.Expression;

public final class BindingTypeAnnotationElement
extends AnnotationElement {
    private Expression value;

    static {
        DEFAULT_VALUES.put(BindingTypePropertyTypes.VALUE, "SOAP11HTTP_BINDING");
    }

    public BindingTypeAnnotationElement(JavaElement parent) {
        super(parent);
    }

    @Override
    protected void setAttributeValue(String identifier, Expression value) {
        BindingTypePropertyTypes type = BindingTypePropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    this.setValue(value);
                    break;
                }
            }
        }
    }

    @Override
    protected Expression getAttribute(String identifier) {
        BindingTypePropertyTypes type = BindingTypePropertyTypes.getPropertyType(identifier);
        if (type != null) {
            switch (type) {
                case VALUE: {
                    return this.getValue();
                }
            }
        }
        return null;
    }

    @Override
    public void writeAttributeValue(String identifier, String value) {
        BindingType type = BindingType.getBindingType(value);
        if (type != null) {
            value = type.getFullyQualifiedConstantName();
        }
        super.writeAttributeValue(identifier, value);
    }

    @Override
    public IAnnotationType getAnnotationType() {
        return AnnotationType.BindingType;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    @Override
    protected IPropertyTypes[] getPropertyTypes() {
        return BindingTypePropertyTypes.values();
    }

    @Override
    public IPropertyTypes getPropertyType(String id) {
        return BindingTypePropertyTypes.getPropertyType(id);
    }

    public static enum BindingType {
        SOAP11HTTP_BINDING("SOAP11HTTP_BINDING", SOAPBinding.class),
        SOAP12HTTP_BINDING("SOAP12HTTP_BINDING", SOAPBinding.class),
        SOAP11HTTP_MTOM_BINDING("SOAP11HTTP_MTOM_BINDING", SOAPBinding.class),
        SOAP12HTTP_MTOM_BINDING("SOAP12HTTP_MTOM_BINDING", SOAPBinding.class),
        HTTP_BINDING("HTTP_BINDING", HTTPBinding.class);

        private Class type;
        private String label;

        private BindingType(String label, Class type) {
            this.type = type;
            this.label = label;
        }

        public static BindingType getBindingType(Class type) {
            if (type != null) {
                BindingType[] bindingTypeArray = BindingType.values();
                int n = bindingTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BindingType bindingTemp = bindingTypeArray[n2];
                    if (bindingTemp.getType().equals(type)) {
                        return bindingTemp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public static BindingType getBindingType(String label) {
            if (label != null) {
                BindingType[] bindingTypeArray = BindingType.values();
                int n = bindingTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BindingType bindingTemp = bindingTypeArray[n2];
                    if (bindingTemp.getLabel().equals(label)) {
                        return bindingTemp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public Class getType() {
            return this.type;
        }

        public String getSimpleName() {
            return this.type.getSimpleName();
        }

        public String getFullyQualifiedName() {
            return this.type.getCanonicalName();
        }

        public String getFullyQualifiedConstantName() {
            return String.valueOf(this.type.getCanonicalName()) + "." + this.getLabel();
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum BindingTypePropertyTypes implements IPropertyTypes
    {
        VALUE("value");

        private String identifier;

        private BindingTypePropertyTypes(String identifier) {
            this.identifier = identifier;
        }

        public static BindingTypePropertyTypes getPropertyType(String identifier) {
            if (identifier != null) {
                BindingTypePropertyTypes[] bindingTypePropertyTypesArray = BindingTypePropertyTypes.values();
                int n = bindingTypePropertyTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BindingTypePropertyTypes temp = bindingTypePropertyTypesArray[n2];
                    if (temp.getIdentifier().equals(identifier)) {
                        return temp;
                    }
                    ++n2;
                }
            }
            return null;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }
    }
}

