/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.properties.jws.context;

import java.util.Map;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.properties.jws.context.ASTPropertyInvocationContext;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.AnnotationElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.ClassElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.FieldElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.JavaElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.MethodElement;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.MethodParameterElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class WebServicePropertyContentProvider
implements IDocumentListener,
ISelectionProvider {
    private final ClassElement classElement = new ClassElement(this);
    private final MethodElement methodElement = new MethodElement(this);
    private final FieldElement fieldElement = new FieldElement(this);
    private final MethodParameterElement methodParameterElement = new MethodParameterElement(this);
    private JavaElement currentSelection;
    private ASTPropertyInvocationContext astContext;
    private ICompilationUnit icompilationUnit;

    public void rewriteAnnotation(final Annotation annotation, final String attrName, final Object value) {
        SafeRunnable code = new SafeRunnable(Messages.jws_properties_annotation_update_failure){

            public void run() throws Exception {
                WebServicePropertyContentProvider.this.astContext.setAnnotationAttribute(annotation, attrName, value);
                WebServicePropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotation(final BodyDeclaration parent, final String fullyQualifiedName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.jws_properties_annotation_update_failure){

            public void run() throws Exception {
                if (attrs != null && !attrs.isEmpty()) {
                    WebServicePropertyContentProvider.this.astContext.addAnnotation(parent, fullyQualifiedName, (Map<String, String>)attrs);
                } else {
                    WebServicePropertyContentProvider.this.astContext.addMarkerAnnotation(parent, fullyQualifiedName);
                }
                WebServicePropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotation(final SingleVariableDeclaration parent, final String fullyQualifiedName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.jws_properties_annotation_update_failure){

            public void run() throws Exception {
                if (attrs != null && !attrs.isEmpty()) {
                    WebServicePropertyContentProvider.this.astContext.addAnnotation(parent, fullyQualifiedName, (Map<String, String>)attrs);
                } else {
                    WebServicePropertyContentProvider.this.astContext.addMarkerAnnotation(parent, fullyQualifiedName);
                }
                WebServicePropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotationWithArrayMember(final BodyDeclaration parent, final String fullyQualifiedName, final String arrayName, final String annotationName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.jws_properties_annotation_update_failure){

            public void run() throws Exception {
                WebServicePropertyContentProvider.this.astContext.addAnnotationWithArrayMember(parent, fullyQualifiedName, arrayName, annotationName, attrs);
                WebServicePropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void addAnnotationArrayMember(final Annotation annotation, final String arrayName, final String annotationName, final Map<String, String> attrs) {
        SafeRunnable code = new SafeRunnable(Messages.jws_properties_annotation_update_failure){

            public void run() throws Exception {
                WebServicePropertyContentProvider.this.astContext.addAnnotationArrayMember(annotation, arrayName, annotationName, attrs);
                WebServicePropertyContentProvider.this.astContext.commitRewrite();
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public void removeAnnotation(final ASTNode node) {
        if (node != null) {
            SafeRunnable code = new SafeRunnable(Messages.jws_properties_annotation_update_failure){

                public void run() throws Exception {
                    WebServicePropertyContentProvider.this.astContext.removeAnnotation(node);
                    WebServicePropertyContentProvider.this.astContext.commitRewrite();
                }
            };
            SafeRunner.run((ISafeRunnable)code);
        }
    }

    public void refresh() {
        this.astContext.initializeEditContext();
        if (this.currentSelection != null) {
            this.currentSelection.refresh(this.getCurrentElementTypeNode());
        }
    }

    public void update() {
        this.astContext.initializeEditContext();
        if (this.currentSelection != null) {
            this.currentSelection.update(this.getCurrentElementTypeNode());
        }
    }

    public boolean hasSelectionChanged(TextSelection selection) {
        if (!this.isEmpty()) {
            Position pos = new Position(selection.getOffset(), selection.getLength());
            ASTNode node = this.astContext.findContainingNode(pos);
            node = this.findElementTypeNode(node);
            return !this.currentSelection.getASTNode().equals((Object)node);
        }
        return true;
    }

    public void selectionChanged(ITextEditor editor, TextSelection selection) {
        IEditorInput input;
        IDocumentProvider provider = editor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)(input = editor.getEditorInput()));
        if (document.get() != null && document.get().length() >= selection.getOffset()) {
            this.icompilationUnit = (ICompilationUnit)JavaUI.getEditorInputJavaElement((IEditorInput)input);
            this.astContext = new ASTPropertyInvocationContext(this.icompilationUnit, document, selection.getOffset(), selection.getLength());
            this.astContext.addPositionUpdater();
            ASTNode node = this.astContext.findContainingNode();
            this.setSelection((ISelection)this.getElement(node));
            this.refresh();
        }
    }

    private JavaElement getElement(ASTNode node) {
        JavaElement.JavaElementType type = this.findElementType(node);
        return this.getJavaElement(type);
    }

    private JavaElement.JavaElementType findElementType(ASTNode node) {
        while (node != null) {
            if (this.classElement.isElementTypeNode(node)) {
                return this.classElement.getType();
            }
            if (this.methodElement.isElementTypeNode(node)) {
                return this.methodElement.getType();
            }
            if (this.fieldElement.isElementTypeNode(node)) {
                return this.fieldElement.getType();
            }
            if (this.methodParameterElement.isElementTypeNode(node)) {
                return this.methodParameterElement.getType();
            }
            if (this.unsupportedNode(node)) {
                return null;
            }
            node = node.getParent();
        }
        return null;
    }

    private ASTNode findElementTypeNode(ASTNode node) {
        while (node != null) {
            if (this.classElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.methodElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.fieldElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.methodParameterElement.isElementTypeNode(node)) {
                return node;
            }
            if (this.unsupportedNode(node)) {
                return null;
            }
            node = node.getParent();
        }
        return null;
    }

    private boolean unsupportedNode(ASTNode node) {
        return node instanceof MethodDeclaration && ((MethodDeclaration)node).isConstructor();
    }

    public String getSelectionTabIdentifier(TextSelection selection) {
        if (!this.isEmpty()) {
            Position pos = new Position(selection.getOffset(), selection.getLength());
            ASTNode node = this.astContext.findContainingNode(pos);
            JavaElement.JavaElementType elementType = this.findElementType(node);
            JavaElement element = this.getJavaElement(elementType);
            Annotation annotationNode = this.findAnnotationNode(node);
            if (annotationNode != null) {
                String name = annotationNode.getTypeName().getFullyQualifiedName();
                for (AnnotationElement annotationElement : element.getAnnotations()) {
                    if (!annotationElement.isEqual(name) && !annotationElement.contains(name)) continue;
                    return annotationElement.getTabIdentifier();
                }
            }
        }
        return null;
    }

    private Annotation findAnnotationNode(ASTNode node) {
        while (node != null) {
            if (node instanceof Annotation) {
                return (Annotation)node;
            }
            node = node.getParent();
        }
        return null;
    }

    private JavaElement getJavaElement(JavaElement.JavaElementType type) {
        if (type != null) {
            switch (type) {
                case CLASS: {
                    return this.classElement;
                }
                case METHOD: {
                    return this.methodElement;
                }
                case METHODPARAMETER: {
                    return this.methodParameterElement;
                }
                case FIELD: {
                    return this.fieldElement;
                }
            }
        }
        return null;
    }

    private ASTNode getCurrentElementTypeNode() {
        ASTNode node = this.astContext.findContainingNode();
        while (node != null) {
            if (this.currentSelection.isElementTypeNode(node)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private void addDocumentListener() {
        if (this.astContext != null && this.astContext.getDocument() != null) {
            this.astContext.getDocument().addDocumentListener((IDocumentListener)this);
        }
    }

    private void removeDocumentListener() {
        if (this.astContext != null && this.astContext.getDocument() != null) {
            this.astContext.getDocument().removeDocumentListener((IDocumentListener)this);
        }
    }

    public boolean isEmpty() {
        return this.currentSelection == null;
    }

    public void startListening() {
        this.addDocumentListener();
    }

    public void dispose() {
        this.removeDocumentListener();
        if (this.astContext != null) {
            this.astContext.removePositionUpdater();
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.refresh();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
        this.currentSelection = selection instanceof JavaElement ? (JavaElement)selection : null;
    }

    public ICompilationUnit getIcompilationUnit() {
        return this.icompilationUnit;
    }
}

