/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.preference;

import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import oracle.eclipse.tools.webservices.ui.policy.preference.IRuntimePolicyStore;
import oracle.eclipse.tools.webservices.ui.policy.preference.WsPolicyStorePreferenceModelResource;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.wst.server.core.IRuntime;

public class RuntimePolicyStoreModelResource
extends Resource {
    private IRuntime runtime = null;
    private WsPolicyStorePreferenceModelResource policyStorePref = null;

    public RuntimePolicyStoreModelResource(Resource parent, Object obj) {
        super(parent);
        this.policyStorePref = (WsPolicyStorePreferenceModelResource)parent;
        this.runtime = (IRuntime)obj;
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IRuntimePolicyStore.PROP_RUNTIME_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return RuntimePolicyStoreModelResource.this.runtime.getName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IRuntimePolicyStore.PROP_POLICY_STORE_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    String value = RuntimePolicyStoreModelResource.this.policyStorePref.getStoreType(RuntimePolicyStoreModelResource.this.runtime);
                    return value != null ? value : "DEFAULT";
                }

                public void write(String value) {
                    RuntimePolicyStoreModelResource.this.policyStorePref.setStoreType(RuntimePolicyStoreModelResource.this.runtime, value);
                }
            };
        }
        if (p == IRuntimePolicyStore.PROP_DEFAULT_STORE_LOCATION) {
            return new ValuePropertyBinding(){

                public String read() {
                    String name = RuntimePolicyStoreModelResource.this.readDefaultLocation();
                    return name;
                }

                public void write(String value) {
                }
            };
        }
        if (p == IRuntimePolicyStore.PROP_OVERRIDE_LOCATION) {
            return new ValuePropertyBinding(){

                public String read() {
                    String name = RuntimePolicyStoreModelResource.this.readOverrideLocation();
                    return name;
                }

                public void write(String value) {
                    RuntimePolicyStoreModelResource.this.policyStorePref.setOverrideLocation(RuntimePolicyStoreModelResource.this.runtime, value);
                }
            };
        }
        if (p == IRuntimePolicyStore.PROP_REMOTE_SERVER) {
            return new ValuePropertyBinding(){

                public String read() {
                    String name = RuntimePolicyStoreModelResource.this.readRemoteServerName();
                    return name;
                }

                public void write(String value) {
                    RuntimePolicyStoreModelResource.this.policyStorePref.setRemoteServerName(RuntimePolicyStoreModelResource.this.runtime, value);
                }
            };
        }
        return null;
    }

    protected String readRemoteServerName() {
        return this.policyStorePref.getRemoteServerName(this.runtime);
    }

    protected String readOverrideLocation() {
        return this.policyStorePref.getOverrideLocation(this.runtime);
    }

    private String readDefaultLocation() {
        String defaultStorePath = WeblogicPolicyUtil.getDefaultOWSMPolicyStoreLocation(this.runtime).getAbsolutePath();
        return defaultStorePath;
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }
}

