/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.model;

import java.net.MalformedURLException;
import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.policy.IPolicyQuery;
import oracle.eclipse.tools.webservices.policy.IWlsWsPolicy;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import oracle.eclipse.tools.webservices.ui.policy.model.IWeblogicWsPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWsPolicyConfig;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyConfigModelResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;

public class WeblogicPolicyNameValueProvider
extends PossibleValuesService {
    private static boolean showOnce = false;

    protected void fillPossibleValues(Set<String> values) {
        IWsPolicyConfig policyCfg = null;
        Element model = (Element)this.context(Element.class);
        if (model instanceof IWsPolicyConfig) {
            policyCfg = (IWsPolicyConfig)model;
        } else if (model instanceof IWeblogicWsPolicy) {
            IWeblogicWsPolicy owsmPolicy = (IWeblogicWsPolicy)model;
            policyCfg = (IWsPolicyConfig)owsmPolicy.parent().element();
        }
        if (policyCfg == null) {
            return;
        }
        WsPolicyConfigModelResource res = (WsPolicyConfigModelResource)policyCfg.resource();
        IRuntime wlsRt = res.getRuntime();
        if (wlsRt == null) {
            return;
        }
        QueryType queryType = (QueryType)policyCfg.getQueryType().content();
        IPolicyQuery pq = WeblogicPolicyUtil.createPolicyQuery(wlsRt, queryType);
        if (pq == null) {
            if (showOnce) {
                return;
            }
            showOnce = true;
            Status sts = new Status(4, "oracle.eclipse.tools.webservices.ui", WebServicesUIMessages.getString("WlsPolicyNameValueProvider_0"));
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)WebServicesUIMessages.getString("WlsPolicyNameValueProvider_1"), (String)WebServicesUIMessages.getString("WlsPolicyNameValueProvider_2"), (IStatus)sts);
            return;
        }
        pq.setQueryType(queryType);
        try {
            for (IWlsWsPolicy p : pq.getWlsPolicies(res.getProject())) {
                values.add(p.getUri());
            }
        }
        catch (MalformedURLException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
    }
}

