/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.eclipse.tools.webservices.policy.IPolicyQuery;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import oracle.eclipse.tools.webservices.ui.policy.model.IOwsmPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWsPolicyConfig;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyConfigModelResource;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.server.core.IRuntime;

public class PolicyCompatabilityValidationService
extends ValidationService {
    protected Status compute() {
        ElementList list = (ElementList)this.context(ElementList.of(IOwsmPolicy.class));
        IWsPolicyConfig policyCfg = (IWsPolicyConfig)list.element();
        if (list.size() == 0) {
            return Status.createOkStatus();
        }
        WsPolicyConfigModelResource res = (WsPolicyConfigModelResource)policyCfg.resource();
        IRuntime wlsRt = res.getRuntime();
        if (wlsRt == null) {
            return Status.createOkStatus();
        }
        QueryType queryType = (QueryType)policyCfg.getQueryType().content();
        IPolicyQuery pq = WeblogicPolicyUtil.createPolicyQuery(wlsRt, queryType);
        if (pq == null) {
            return Status.createOkStatus();
        }
        pq.setQueryType(queryType);
        ArrayList<String> policies = new ArrayList<String>();
        for (IOwsmPolicy p : list) {
            policies.add((String)p.getPolicyName().content());
        }
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        Collection errors = pq.validatePoliciesFromName(policies);
        if (errors != null && errors.size() > 0) {
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                factory.merge(Status.createErrorStatus((String)((String)iterator.next())));
            }
            return factory.create();
        }
        return Status.createOkStatus();
    }
}

