/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.policy.IOWSMWsPolicy;
import oracle.eclipse.tools.webservices.policy.IPolicyQuery;
import oracle.eclipse.tools.webservices.policy.PolicyType;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.policy.WeblogicPolicyUtil;
import oracle.eclipse.tools.webservices.ui.policy.model.IOwsmPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWsPolicyConfig;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyConfigModelResource;
import oracle.eclipse.tools.webservices.ui.policy.model.YesNoEnum;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;

public class OwsmPolicyNameValueProvider
extends PossibleValuesService {
    private static boolean showOnce = false;
    private Map<String, List<IOWSMWsPolicy>> _queryCompatCache = new HashMap<String, List<IOWSMWsPolicy>>();

    protected void fillPossibleValues(Set<String> values) {
        IWsPolicyConfig policyCfg = null;
        Element model = (Element)this.context(Element.class);
        if (model instanceof IOwsmPolicy) {
            IOwsmPolicy owsmPolicy = (IOwsmPolicy)model;
            policyCfg = (IWsPolicyConfig)owsmPolicy.parent().element();
        } else if (model instanceof IWsPolicyConfig) {
            policyCfg = (IWsPolicyConfig)model;
        }
        if (policyCfg == null) {
            return;
        }
        WsPolicyConfigModelResource res = (WsPolicyConfigModelResource)policyCfg.resource();
        IRuntime wlsRt = res.getRuntime();
        if (wlsRt == null) {
            return;
        }
        QueryType queryType = (QueryType)policyCfg.getQueryType().content();
        final IPolicyQuery pq = WeblogicPolicyUtil.createPolicyQuery(wlsRt, queryType);
        if (pq == null) {
            if (showOnce) {
                return;
            }
            showOnce = true;
            Status sts = new Status(4, "oracle.eclipse.tools.webservices.ui", WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_0"));
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_1"), (String)WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_2"), (IStatus)sts);
            return;
        }
        pq.setQueryType(queryType);
        final ArrayList clientCompatList = new ArrayList();
        if (QueryType.CLIENT.equals((Object)queryType)) {
            Enum enabled = (Enum)policyCfg.getShowCompat().content(true);
            final String oraWsdl = (String)policyCfg.getWsdlDefinition().content();
            final String serviceName = (String)policyCfg.getServiceName().content();
            final String portName = (String)policyCfg.getPortName().content();
            final String namespace = (String)policyCfg.getServiceNameSpace().content();
            if (YesNoEnum.YES.equals(enabled) && oraWsdl != null && serviceName != null && portName != null && namespace != null) {
                if (this._queryCompatCache.containsKey(serviceName)) {
                    clientCompatList.addAll(this._queryCompatCache.get(serviceName));
                } else {
                    String cfr_ignored_0 = (String)policyCfg.getServiceNamePrefix().content(true);
                    IRunnableWithProgress op = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_3"), 100);
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    clientCompatList.addAll(pq.getCompatibleClientPoliciesFor(oraWsdl, new QName(namespace, serviceName, ""), portName, PolicyType.SECURITY.getName()));
                                }
                            };
                            t.start();
                            while (t.isAlive()) {
                                monitor.worked(1);
                                Thread.sleep(200L);
                            }
                            monitor.done();
                        }
                    };
                    try {
                        new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, op);
                    }
                    catch (InvocationTargetException e) {
                        LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                    }
                }
                this._queryCompatCache.put(serviceName, clientCompatList);
            }
        }
        final ArrayList policies = new ArrayList();
        if (clientCompatList.size() > 0) {
            policies.addAll(clientCompatList);
        } else if (pq.isOWSMPoliciesCachedFor(PolicyType.SECURITY)) {
            policies.addAll(pq.getOWSMPoliciesForType(PolicyType.SECURITY));
        } else {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(WebServicesUIMessages.getString("OwsmPolicyNameValueProvider_3"), 100);
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            policies.addAll(pq.getOWSMPoliciesForType(PolicyType.SECURITY));
                        }
                    };
                    t.start();
                    while (t.isAlive()) {
                        monitor.worked(1);
                        Thread.sleep(200L);
                    }
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, op);
            }
            catch (InvocationTargetException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (InterruptedException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
        }
        for (IOWSMWsPolicy p : policies) {
            values.add(p.getName());
        }
    }
}

