/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.webservices.policy.IOWSMWsPolicy;
import oracle.eclipse.tools.webservices.policy.IPolicyQuery;
import oracle.eclipse.tools.webservices.policy.PolicyType;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import oracle.eclipse.tools.webservices.ui.WebServicesUIMessages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.policy.preference.IRuntimePolicyStore;
import oracle.eclipse.tools.webservices.ui.policy.preference.IWsPolicyStorePreference;
import oracle.eclipse.tools.webservices.ui.policy.preference.PolicyStoreType;
import oracle.eclipse.tools.webservices.ui.policy.preference.WsPolicyStorePreferenceModelFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public class WeblogicPolicyUtil {
    private static HashMap<IRuntime, IPolicyQuery> policyQueryCache = new HashMap();
    private static HashMap<IRuntime, IPolicyQuery> clientPolicyQueryCache = new HashMap();
    private static Map<IRuntime, Map<String, String>> policyDescriptionCache = new HashMap<IRuntime, Map<String, String>>();
    private static Map<IRuntime, Map<String, String>> clientPolicyDescriptionCache = new HashMap<IRuntime, Map<String, String>>();

    public static File getDefaultOWSMPolicyStoreLocation(IRuntime wlsRt) {
        String normalizedId;
        File storePath;
        IPath root = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        File storeRoot = root.append("WsPolicy/oracle/store/gmds").toFile();
        if (!storeRoot.exists()) {
            storeRoot.mkdirs();
        }
        if (!(storePath = new File(storeRoot, normalizedId = wlsRt.getId().replace(' ', '-'))).exists()) {
            storePath.mkdirs();
        }
        return storePath;
    }

    public static void resetPolicyQueryCache() {
        policyQueryCache.clear();
        clientPolicyQueryCache.clear();
        policyDescriptionCache.clear();
        clientPolicyDescriptionCache.clear();
    }

    private static IRuntimePolicyStore findPolicyStore(IRuntime wlsRt) {
        IPreferenceStore preferenceStore = WebServicesUIPlugin.getDefault().getPreferenceStore();
        IWsPolicyStorePreference wsPolicyPref = WsPolicyStorePreferenceModelFactory.create(preferenceStore);
        for (IRuntimePolicyStore store : wsPolicyPref.getRuntimePolicyStore()) {
            String name = (String)store.getRuntimeName().content();
            if (!name.equals(wlsRt.getName())) continue;
            return store;
        }
        return null;
    }

    public static IPolicyQuery createPolicyQuery(IRuntime wlsRt, QueryType type) {
        IPolicyQuery policyQuery = null;
        policyQuery = QueryType.CLIENT.equals((Object)type) ? clientPolicyQueryCache.get(wlsRt) : policyQueryCache.get(wlsRt);
        if (policyQuery != null) {
            return policyQuery;
        }
        File owsmStorePath = WeblogicPolicyUtil.getDefaultOWSMPolicyStoreLocation(wlsRt);
        boolean seedOwsmStore = true;
        IRuntimePolicyStore policyStore = WeblogicPolicyUtil.findPolicyStore(wlsRt);
        if (policyStore == null) {
            return null;
        }
        if (policyStore.getPolicyStoreType().content() == PolicyStoreType.REMOTE) {
            String remoteWlsName = (String)policyStore.getRemoteServer().content();
            for (IServer s : WebLogicServerUtil.getWebLogicServers()) {
                if (!s.getName().endsWith(remoteWlsName)) continue;
                if (s.getServerState() != 2) {
                    return null;
                }
                WeblogicServer weblogic = (WeblogicServer)s.getAdapter(WeblogicServer.class);
                policyQuery = WeblogicPolicyUtil.createRemotePolicyQuery(wlsRt, owsmStorePath, weblogic, type);
            }
        } else {
            File file;
            if (policyStore.getPolicyStoreType().content() == PolicyStoreType.OVERRIDE && (file = ((Path)policyStore.getOverrideLocation().content()).toFile()).exists()) {
                owsmStorePath = file;
            }
            policyQuery = WeblogicPolicyUtil.createPolicyQuery(wlsRt, owsmStorePath, seedOwsmStore);
        }
        if (QueryType.CLIENT.equals((Object)type)) {
            clientPolicyQueryCache.put(wlsRt, policyQuery);
        } else {
            policyQueryCache.put(wlsRt, policyQuery);
        }
        return policyQuery;
    }

    public static IPolicyQuery createRemotePolicyQuery(final IRuntime wlsRt, final File defaultStorePath, final WeblogicServer weblogic, final QueryType type) {
        final IPolicyQuery[] policyQuery = new IPolicyQuery[]{null};
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(WebServicesUIMessages.getString("creatingOwsmPolicy"), 100);
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt = RuntimeBridgeUtil.bridge((IRuntime)wlsRt);
                final WSRuntime wsRt = (WSRuntime)frt.getAdapter(WSRuntime.class);
                monitor.worked(20);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        policyQuery[0] = wsRt.getPolicyQuery(wlsRt);
                        if (policyQuery[0] == null) {
                            return;
                        }
                        policyQuery[0].setRemoteWeblogicServer(weblogic);
                        if (QueryType.CLIENT.equals((Object)type)) {
                            policyQuery[0].setStorePath(defaultStorePath.getAbsolutePath());
                        }
                    }
                };
                t.start();
                while (t.isAlive()) {
                    monitor.worked(1);
                    Thread.sleep(100L);
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, op);
        }
        catch (InvocationTargetException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        return policyQuery[0];
    }

    public static IPolicyQuery createPolicyQuery(final IRuntime wlsRt, final File storePath, final boolean seedPolicyStore) {
        final IPolicyQuery[] policyQuery = new IPolicyQuery[]{null};
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(WebServicesUIMessages.getString("creatingOwsmPolicy"), 100);
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt = RuntimeBridgeUtil.bridge((IRuntime)wlsRt);
                final WSRuntime wsRt = (WSRuntime)frt.getAdapter(WSRuntime.class);
                monitor.worked(20);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        policyQuery[0] = wsRt.getPolicyQuery(wlsRt);
                        if (policyQuery[0] == null) {
                            return;
                        }
                        if (storePath != null) {
                            try {
                                if (seedPolicyStore && !storePath.exists()) {
                                    policyQuery[0].seedOwsmPoliciesAtFileStore(storePath);
                                }
                                policyQuery[0].setStorePath(storePath.getAbsolutePath());
                            }
                            catch (Exception e) {
                                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                            }
                        }
                    }
                };
                t.start();
                while (t.isAlive()) {
                    monitor.worked(1);
                    Thread.sleep(100L);
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(false, false, op);
        }
        catch (InvocationTargetException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (InterruptedException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        return policyQuery[0];
    }

    public static void seedOwsmPoliciesAtFileStore(IRuntime wlsRt, File storeLocation) throws Exception {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt = RuntimeBridgeUtil.bridge((IRuntime)wlsRt);
        WSRuntime wsRt = (WSRuntime)frt.getAdapter(WSRuntime.class);
        IPolicyQuery pq = wsRt.getPolicyQuery(wlsRt);
        if (pq == null) {
            throw new Exception("Failed to create OWSM policy query");
        }
        pq.seedOwsmPoliciesAtFileStore(storeLocation);
    }

    public static String getPolicyDescription(IRuntime rt, String policyName, QueryType type) {
        if (QueryType.SERVER.equals((Object)type)) {
            Map<String, String> policyDescriptions = policyDescriptionCache.get(rt);
            if (policyDescriptions == null) {
                policyDescriptions = new HashMap<String, String>();
                policyDescriptionCache.put(rt, policyDescriptions);
                IPolicyQuery pq = WeblogicPolicyUtil.createPolicyQuery(rt, QueryType.SERVER);
                List policies = pq.getOWSMPoliciesForType(PolicyType.SECURITY);
                for (IOWSMWsPolicy p : policies) {
                    policyDescriptions.put(p.getName(), p.getDescription());
                }
            }
            return policyDescriptions.get(policyName);
        }
        Map<String, String> policyDescriptions = clientPolicyDescriptionCache.get(rt);
        if (policyDescriptions == null) {
            policyDescriptions = new HashMap<String, String>();
            clientPolicyDescriptionCache.put(rt, policyDescriptions);
            IPolicyQuery pq = WeblogicPolicyUtil.createPolicyQuery(rt, QueryType.CLIENT);
            List policies = pq.getOWSMPoliciesForType(PolicyType.SECURITY);
            for (IOWSMWsPolicy p : policies) {
                policyDescriptions.put(p.getName(), p.getDescription());
            }
        }
        return policyDescriptions.get(policyName);
    }
}

