/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.webservices.policy.PolicyType;
import oracle.eclipse.tools.webservices.policy.QueryType;
import oracle.eclipse.tools.webservices.ui.policy.IPolicySelectionPanel;
import oracle.eclipse.tools.webservices.ui.policy.model.IOwsmPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWeblogicWsPolicy;
import oracle.eclipse.tools.webservices.ui.policy.model.IWsPolicyConfig;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyConfigModelFactory;
import oracle.eclipse.tools.webservices.ui.policy.model.WsPolicyRuntimeType;
import oracle.eclipse.tools.webservices.ui.policy.model.WsdlInfo;
import oracle.eclipse.tools.webservices.ui.policy.model.YesNoEnum;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;

public class WebServiceClientPolicySelectionPanel
implements IPolicySelectionPanel {
    private static final String SELECTION_PANEL_SDEF = "client.panel";
    private static final String OWSM_PANEL_SDEF = "owsm.client.panel";
    private static final String WLS_PANEL_SDEF = "weblogic.panel";
    private IWsPolicyConfig model = null;
    private WsdlInfo wsdlInfo;
    private WsPolicyRuntimeType policyOption = WsPolicyRuntimeType.NONE;
    private QueryType queryType = QueryType.CLIENT;
    private IRuntime wlsRt = null;
    private IProject project = null;
    private Set<String> selection = Collections.emptySet();
    private List<String> existingOwsmPolicies = new ArrayList<String>();
    private List<String> existingWlsPolicies = new ArrayList<String>();

    private String getSdefName() {
        if (WsPolicyRuntimeType.OWSM == this.policyOption) {
            return OWSM_PANEL_SDEF;
        }
        if (WsPolicyRuntimeType.WEBLOGIC == this.policyOption) {
            return WLS_PANEL_SDEF;
        }
        return SELECTION_PANEL_SDEF;
    }

    public void setWsPolicyRuntimeType(WsPolicyRuntimeType policyOption) {
        if (policyOption != null) {
            this.policyOption = policyOption;
        }
    }

    public WsPolicyRuntimeType getWsPolicyRuntimeType() {
        return this.policyOption;
    }

    @Override
    public WsPolicyRuntimeType getSelectedWsPolicyRuntimeType() {
        return (WsPolicyRuntimeType)((Object)this.model.getPolicyRuntimeType().content());
    }

    @Override
    public void setProject(IProject proj) {
        this.project = proj;
    }

    @Override
    public Composite createControl(Composite parent, IRuntime wlsRt) {
        this.wlsRt = wlsRt;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdfill());
        composite.setLayout((Layout)SwtUtil.glayout((int)1));
        this.model = WsPolicyConfigModelFactory.create(this.wlsRt, this.project, this.getWsPolicyRuntimeType(), this.existingOwsmPolicies, this.existingWlsPolicies);
        this.model.setQueryType(this.queryType);
        this.setWSDLInfo(this.wsdlInfo);
        GridData gd = SwtUtil.gdfill();
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 640;
        gd.heightHint = 360;
        SapphireForm wsPolicyPrefPanel = new SapphireForm(composite, (Element)this.model, DefinitionLoader.context(this.getClass()).sdef("WebServicePolicySelection").form(this.getSdefName()));
        wsPolicyPrefPanel.setLayoutData((Object)gd);
        return composite;
    }

    @Override
    public Set<String> getSelections(PolicyType type) {
        this.selection = new HashSet<String>();
        WsPolicyRuntimeType prt = (WsPolicyRuntimeType)((Object)this.model.getPolicyRuntimeType().content());
        if (PolicyType.SECURITY.equals((Object)type)) {
            if (WsPolicyRuntimeType.OWSM == prt) {
                if (YesNoEnum.NO.equals(this.model.getShowCompat().content(true))) {
                    for (IOwsmPolicy p : this.model.getOwsmPolicies()) {
                        this.selection.add((String)p.getPolicyName().content());
                    }
                } else {
                    for (IOwsmPolicy p : this.model.getOwsmCompatPolicies()) {
                        this.selection.add((String)p.getPolicyName().content());
                    }
                }
            } else if (WsPolicyRuntimeType.WEBLOGIC == prt) {
                for (IWeblogicWsPolicy p : this.model.getWeblogicPolicies()) {
                    String uri = (String)p.getPolicyName().content();
                    this.selection.add(uri);
                }
            }
        } else if (PolicyType.MTOM.equals((Object)type)) {
            if (WsPolicyRuntimeType.OWSM == prt && this.model.getOwsmMtomPolicy() != null && this.model.getOwsmMtomPolicy().content() != null) {
                this.selection.add((String)this.model.getOwsmMtomPolicy().content());
            }
        } else if (PolicyType.RELIABILITY.equals((Object)type)) {
            if (WsPolicyRuntimeType.OWSM == prt && this.model.getOwsmReliabilityPolicy() != null && this.model.getOwsmReliabilityPolicy().content() != null) {
                this.selection.add((String)this.model.getOwsmReliabilityPolicy().content());
            }
        } else if (PolicyType.ADDRESSING.equals((Object)type) && WsPolicyRuntimeType.OWSM == prt && this.model.getOwsmAddressingPolicy() != null && this.model.getOwsmAddressingPolicy().content() != null) {
            this.selection.add((String)this.model.getOwsmAddressingPolicy().content());
        }
        return this.selection;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    @Override
    public void setWSDLInfo(WsdlInfo wsdlInfo) {
        if (wsdlInfo != null) {
            if (this.model == null) {
                this.wsdlInfo = wsdlInfo;
            } else {
                this.model.setWsdlDefinition(wsdlInfo.getWsdlDef());
                this.model.setServiceName(wsdlInfo.getServiceName());
                this.model.setPortName(wsdlInfo.getPortName());
                this.model.setServiceNameSpace(wsdlInfo.getTargetNamespace());
                this.model.setServiceNamePrefix(wsdlInfo.getPrefix());
                this.model.setWsdlPolicyEnabled(wsdlInfo.hasPolicies());
            }
        }
    }
}

