/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSOperationParameter;
import oracle.eclipse.tools.webservices.model.jws.LayeredListPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ModelPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.internal.JWSOperationResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IEndpointInterface;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IFaultNode;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IMethod;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IMethodParameter;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.AbstractBindingsModelResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.FaultNodeResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.MethodParameterResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListPropertyBinding;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;

public class MethodResource
extends AbstractBindingsModelResource<JWSOperation> {
    private ValuePropertyMapper<Value<String>> operationName;
    private ValuePropertyMapper<Value<String>> methodName;
    private ValuePropertyMapper<Value<String>> javaDoc;
    private ValuePropertyMapper<Value<Boolean>> asyncMapping;
    private ValuePropertyMapper<Value<Boolean>> wrapperStyle;
    private LayeredListPropertyMapper<JWSOperationParameter, IMethodParameter> parameters;

    public MethodResource(Resource resource, JWSOperation operation) {
        super(resource, operation);
    }

    public void init(Element element) {
        super.init(element);
        this.operationName = new ValuePropertyMapper(JWSOperation.PROP_OPERATION_NAME, (Element)this.getBase(), IMethod.PROP_OPERATION_NAME, this.element());
        this.methodName = new ValuePropertyMapper(JWSOperation.PROP_METHOD_NAME, (Element)this.getBase(), IMethod.PROP_METHOD_NAME, this.element());
        this.javaDoc = new ValuePropertyMapper(JWSOperation.PROP_JAVA_DOC, (Element)this.getBase(), IMethod.PROP_METHOD_JAVADOC, this.element());
        this.wrapperStyle = new ValuePropertyMapper(JWSOperation.PROP_WRAPPER_STYLE_ENABLED, (Element)this.getBase(), IMethod.PROP_WRAPPER_STYLE_ENABLED, this.element());
        this.asyncMapping = new ValuePropertyMapper(JWSOperation.PROP_ASYNC_ENABLED, (Element)this.getBase(), IMethod.PROP_ASYNC_MAPPING_ENABLED, this.element());
        this.parameters = new LayeredListPropertyMapper(JWSOperation.PROP_PARAMETERS, (Element)this.getBase(), IMethod.PROP_PARAMETERS, this.element(), (LayeredListPropertyMapper.IListResourceFactory)new LayeredListPropertyMapper.IListResourceFactory<JWSOperationParameter, IMethodParameter>(){

            public Resource createNewResource(ElementType type, JWSOperationParameter fromElement, ElementList<IMethodParameter> parent) {
                return new MethodParameterResource((Resource)MethodResource.this, fromElement);
            }

            public ElementType type(Resource resource) {
                return IMethodParameter.TYPE;
            }

            public void setUnderlyingElementForType(ElementType type, JWSOperationParameter fromElement) {
            }
        });
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.methodName);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.wrapperStyle);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.asyncMapping);
    }

    @Override
    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IMethod.PROP_OPERATION_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return MethodResource.this.getOperationName();
                }

                public void write(String value) {
                    MethodResource.this.setOperationName(value);
                }
            };
        }
        if (p == IMethod.PROP_METHOD_NAME) {
            return this.createValuePropertyMapperBinding(this.methodName);
        }
        if (p == IMethod.PROP_METHOD_JAVADOC) {
            return this.createValuePropertyMapperBinding(this.javaDoc);
        }
        if (p == IMethod.PROP_WRAPPER_STYLE_ENABLED) {
            return this.createValuePropertyMapperBinding(this.wrapperStyle);
        }
        if (p == IMethod.PROP_ASYNC_MAPPING_ENABLED) {
            return this.createValuePropertyMapperBinding(this.asyncMapping);
        }
        if (p == IMethod.PROP_PARAMETERS) {
            return this.parameters;
        }
        if (p == IMethod.PROP_FAULT_NODES) {
            ListPropertyBinding controller = new ListPropertyBinding(){
                private List<Resource> list = new ArrayList<Resource>();

                public List<Resource> read() {
                    if (this.list.isEmpty() && ((JWSOperation)MethodResource.this.getBase()).getFaults().size() > 0) {
                        FaultNodeResource faultResource = new FaultNodeResource((Resource)MethodResource.this, (JWSOperation)MethodResource.this.getBase());
                        this.list.add((Resource)faultResource);
                    }
                    return this.list;
                }

                public Resource insert(ElementType type, int position) {
                    Resource resource = this.insert(type);
                    this.move(resource, position);
                    return resource;
                }

                private Resource insert(ElementType type) {
                    FaultNodeResource faultResource = new FaultNodeResource((Resource)MethodResource.this, (JWSOperation)MethodResource.this.getBase());
                    return faultResource;
                }

                public ElementType type(Resource resource) {
                    return IFaultNode.TYPE;
                }
            };
            return controller;
        }
        if (p == IMethod.PROP_DISPLAY_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return MethodResource.this.getDisplayName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IMethod.PROP_DISPLAY_NAME_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return MethodResource.this.getDisplayNameTypeString();
                }

                public void write(String value) {
                    MethodResource.this.setDisplayNameTypeString(value);
                }
            };
        }
        return null;
    }

    public String getOperationName() {
        return this.operationName.read();
    }

    public void setOperationName(String operationName) {
        ((JWSOperation)this.getBase()).setOperationName(operationName);
        ((Element)this.parent()).property(IEndpointInterface.PROP_METHODS).refresh();
        this.element().property(IMethod.PROP_PARAMETERS).refresh();
    }

    public void removeBinding() {
        ((JWSOperationResource)((JWSOperation)this.getBase()).resource()).removeOperationBinding();
    }

    @Override
    protected ValueProperty getJavaNameValueProperty() {
        return IMethod.PROP_METHOD_NAME;
    }

    @Override
    protected ValueProperty getWSDLNameValueProperty() {
        return IMethod.PROP_OPERATION_NAME;
    }
}

