/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal;

import oracle.eclipse.tools.common.util.jdt.ClassUtil;
import oracle.eclipse.tools.webservices.model.jws.JWSHandler;
import oracle.eclipse.tools.webservices.model.jws.JWSHandlerChain;
import oracle.eclipse.tools.webservices.model.jws.JWSHandlerType;
import oracle.eclipse.tools.webservices.model.jws.LayeredListPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IHandler;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IHandlerChain;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.ILogicalHandler;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.ISOAPHandler;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.AbstractBindingsModelResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.HandlerResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.LogicalHandlerResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.SOAPHandlerResource;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValuePropertyBinding;

public class HandlerChainResource
extends AbstractBindingsModelResource<JWSHandlerChain> {
    private ValuePropertyMapper<Value<String>> serviceName;
    private ValuePropertyMapper<Value<String>> portName;
    private ValuePropertyMapper<Value<String>> protocol;
    private LayeredListPropertyMapper<JWSHandler, IHandler> handlers;

    public HandlerChainResource(Resource resource, JWSHandlerChain handlerChain) {
        super(resource, handlerChain);
    }

    public void init(Element element) {
        super.init(element);
        this.serviceName = new ValuePropertyMapper(JWSHandlerChain.PROP_SERVICE_NAME, (Element)this.getBase(), IHandlerChain.PROP_SERVICE_NAME_PATTERN_VALUE, this.element());
        this.portName = new ValuePropertyMapper(JWSHandlerChain.PROP_PORT_NAME, (Element)this.getBase(), IHandlerChain.PROP_PORT_NAME_PATTERN_VALUE, this.element());
        this.protocol = new ValuePropertyMapper(JWSHandlerChain.PROP_PROTOCOL, (Element)this.getBase(), IHandlerChain.PROP_PROTOCOL_BINDINGS, this.element());
        this.handlers = new LayeredListPropertyMapper(JWSHandlerChain.PROP_HANDLERS, (Element)this.getBase(), IHandlerChain.PROP_HANDLERS, this.element(), (LayeredListPropertyMapper.IListResourceFactory)new LayeredListPropertyMapper.IListResourceFactory<JWSHandler, IHandler>(){

            public Resource createNewResource(ElementType type, JWSHandler fromElement, ElementList<IHandler> parent) {
                return HandlerChainResource.this.createHandler(type, fromElement, (Resource)HandlerChainResource.this);
            }

            public void setUnderlyingElementForType(ElementType type, JWSHandler fromElement) {
                if (type == ISOAPHandler.TYPE) {
                    fromElement.setHandlerType(JWSHandlerType.SOAP);
                    return;
                }
                fromElement.setHandlerType(JWSHandlerType.LOGICAL);
            }

            public ElementType type(Resource resource) {
                if (resource instanceof SOAPHandlerResource) {
                    return ISOAPHandler.TYPE;
                }
                return ILogicalHandler.TYPE;
            }
        });
    }

    @Override
    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IHandlerChain.PROP_HANDLERS) {
            return this.handlers;
        }
        if (p == IHandlerChain.PROP_SERVICE_NAME_PATTERN_VALUE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return HandlerChainResource.this.getServiceNamePatternValue();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IHandlerChain.PROP_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return HandlerChainResource.this.getType();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IHandlerChain.PROP_PORT_NAME_PATTERN_VALUE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return HandlerChainResource.this.getPortNamePatternValue();
                }

                public void write(String value) {
                    HandlerChainResource.this.setPortNamePatternValue(value);
                }
            };
        }
        if (p == IHandlerChain.PROP_PROTOCOL_BINDINGS) {
            return new ValuePropertyBinding(){

                public String read() {
                    return HandlerChainResource.this.getProtocolBindings();
                }

                public void write(String value) {
                    HandlerChainResource.this.setProtocolBindings(value);
                }
            };
        }
        if (p == IHandlerChain.PROP_APPLIES_TO) {
            return new ValuePropertyBinding(){

                public String read() {
                    return HandlerChainResource.this.getAppliesTo();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IHandlerChain.PROP_DISPLAY_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return HandlerChainResource.this.getDisplayName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IHandlerChain.PROP_DISPLAY_NAME_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return HandlerChainResource.this.getDisplayNameTypeString();
                }

                public void write(String value) {
                    HandlerChainResource.this.setDisplayNameTypeString(value);
                }
            };
        }
        return null;
    }

    public String getType() {
        boolean protocolConfigured;
        boolean serviceConfigured = this.getServiceNamePatternValue() != null;
        boolean portConfigured = this.getPortNamePatternValue() != null;
        boolean bl = protocolConfigured = this.getProtocolBindings() != null;
        String type = !serviceConfigured && !portConfigured && !protocolConfigured ? Messages.jaxws_custom_bindings_file_editor_handler_chain_type_global_label : (serviceConfigured && !portConfigured && !protocolConfigured ? Messages.jaxws_custom_bindings_file_editor_handler_chain_type_service_label : (!serviceConfigured && portConfigured && !protocolConfigured ? Messages.jaxws_custom_bindings_file_editor_handler_chain_type_port_label : (!serviceConfigured && !portConfigured && protocolConfigured ? Messages.jaxws_custom_bindings_file_editor_handler_chain_type_protocol_label : Messages.jaxws_custom_bindings_file_editor_handler_chain_type_unknown_label)));
        return type;
    }

    public String getAppliesTo() {
        boolean protocolConfigured;
        boolean serviceConfigured = this.getServiceNamePatternValue() != null;
        boolean portConfigured = this.getPortNamePatternValue() != null;
        boolean bl = protocolConfigured = this.getProtocolBindings() != null;
        String appliesTo = !serviceConfigured && !portConfigured && !protocolConfigured ? Messages.jaxws_custom_bindings_file_editor_handler_chain_applies_to_global_label : (serviceConfigured && !portConfigured && !protocolConfigured ? this.getServiceNamePatternValue() : (!serviceConfigured && portConfigured && !protocolConfigured ? this.getPortNamePatternValue() : (!serviceConfigured && !portConfigured && protocolConfigured ? this.getProtocolBindings() : Messages.jaxws_custom_bindings_file_editor_handler_chain_applies_to_unknown_label)));
        return appliesTo;
    }

    public String getServiceNamePatternValue() {
        return this.serviceName.read();
    }

    public void setServiceNamePatternValue(String value) {
        this.serviceName.setValue((Object)value);
    }

    public void setPortNamePatternNamespace(String namespace) {
    }

    public String getPortNamePatternValue() {
        return this.portName.read();
    }

    public void setPortNamePatternValue(String value) {
        this.portName.setValue((Object)value);
    }

    public String getProtocolBindings() {
        return this.protocol.read();
    }

    public void setProtocolBindings(String protocolBindings) {
        this.protocol.setValue((Object)protocolBindings);
    }

    private HandlerResource createHandler(ElementType type, JWSHandler jwsHandler, Resource resource) {
        String className = jwsHandler.getClassName().text();
        if (className != null && !className.trim().equals("")) {
            IProject eclipseProject = (IProject)jwsHandler.adapt(IProject.class);
            type = ClassUtil.isAssignableFrom((String)className, (String)"javax.xml.ws.handler.LogicalHandler", (IProject)eclipseProject) ? ILogicalHandler.TYPE : ISOAPHandler.TYPE;
        } else if (type == null) {
            JWSHandlerType handlerType = (JWSHandlerType)jwsHandler.getHandlerType().content();
            type = handlerType != null ? (JWSHandlerType.SOAP.equals((Object)handlerType) ? ISOAPHandler.TYPE : ILogicalHandler.TYPE) : ISOAPHandler.TYPE;
        }
        if (type == ISOAPHandler.TYPE) {
            jwsHandler.setHandlerType(JWSHandlerType.SOAP);
            return new SOAPHandlerResource(resource, jwsHandler);
        }
        jwsHandler.setHandlerType(JWSHandlerType.LOGICAL);
        return new LogicalHandlerResource(resource, jwsHandler);
    }
}

