/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal;

import oracle.eclipse.tools.webservices.model.jws.JWSModel;
import oracle.eclipse.tools.webservices.model.jws.JWSOperation;
import oracle.eclipse.tools.webservices.model.jws.JWSService;
import oracle.eclipse.tools.webservices.model.jws.LayeredListPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ModelPropertyMapper;
import oracle.eclipse.tools.webservices.model.jws.ValuePropertyMapper;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IEndpointInterface;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IMethod;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.IService;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.AbstractBindingsModelResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.MethodResource;
import oracle.eclipse.tools.webservices.ui.editors.bindings.jaxws.model.internal.ServiceResource;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;

public class EndpointInterfaceResource
extends AbstractBindingsModelResource<JWSModel> {
    private ValuePropertyMapper<Value<String>> portTypeName;
    private ValuePropertyMapper<Value<String>> interfaceName;
    private ValuePropertyMapper<Value<String>> javaDoc;
    private ValuePropertyMapper<Value<Boolean>> asyncMapping;
    private ValuePropertyMapper<Value<Boolean>> wrapperStyle;
    private LayeredListPropertyMapper<JWSService, IService> services;
    private LayeredListPropertyMapper<JWSOperation, IMethod> methods;
    private JWSModel model;

    public EndpointInterfaceResource(Resource resource, JWSModel model) {
        super(resource, model);
        this.model = model;
    }

    public void init(Element element) {
        super.init(element);
        this.portTypeName = new ValuePropertyMapper(JWSModel.PROP_SERVICE_NAME, (Element)this.model, IEndpointInterface.PROP_PORT_TYPE_NAME, element);
        this.interfaceName = new ValuePropertyMapper(JWSModel.PROP_CLASS_NAME, (Element)this.model, IEndpointInterface.PROP_INTERFACE_NAME, element);
        this.javaDoc = new ValuePropertyMapper(JWSModel.PROP_JAVA_DOC, (Element)this.model, IEndpointInterface.PROP_INTERFACE_JAVADOC, element);
        this.wrapperStyle = new ValuePropertyMapper(JWSModel.PROP_WRAPPER_STYLE_ENABLED, (Element)this.model, IEndpointInterface.PROP_WRAPPER_STYLE_ENABLED, element);
        this.asyncMapping = new ValuePropertyMapper(JWSModel.PROP_ASYNC_ENABLED, (Element)this.model, IEndpointInterface.PROP_ASYNC_MAPPING_ENABLED, element);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.portTypeName);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.interfaceName);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.javaDoc);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.wrapperStyle);
        this.registerMapper((ModelPropertyMapper<ValueProperty>)this.asyncMapping);
    }

    @Override
    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IEndpointInterface.PROP_SERVICES) {
            this.services = new LayeredListPropertyMapper(JWSModel.PROP_SERVICES, (Element)this.model, IEndpointInterface.PROP_SERVICES, this.element(), (LayeredListPropertyMapper.IListResourceFactory)new LayeredListPropertyMapper.IListResourceFactory<JWSService, IService>(){

                public Resource createNewResource(ElementType type, JWSService fromElement, ElementList<IService> parent) {
                    return new ServiceResource((Resource)EndpointInterfaceResource.this, fromElement);
                }

                public ElementType type(Resource resource) {
                    return IService.TYPE;
                }

                public void setUnderlyingElementForType(ElementType type, JWSService fromElement) {
                }
            });
            return this.services;
        }
        if (p == IEndpointInterface.PROP_METHODS) {
            this.methods = new LayeredListPropertyMapper(JWSModel.PROP_OPERATIONS, (Element)this.model, IEndpointInterface.PROP_METHODS, this.element(), (LayeredListPropertyMapper.IListResourceFactory)new LayeredListPropertyMapper.IListResourceFactory<JWSOperation, IMethod>(){

                public Resource createNewResource(ElementType type, JWSOperation fromElement, ElementList<IMethod> parent) {
                    return new MethodResource((Resource)EndpointInterfaceResource.this, fromElement);
                }

                public ElementType type(Resource resource) {
                    return IMethod.TYPE;
                }

                public void setUnderlyingElementForType(ElementType type, JWSOperation fromElement) {
                }
            });
            return this.methods;
        }
        if (p == IEndpointInterface.PROP_DISPLAY_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return EndpointInterfaceResource.this.getDisplayName();
                }

                public void write(String value) {
                }
            };
        }
        if (p == IEndpointInterface.PROP_DISPLAY_NAME_TYPE) {
            return new ValuePropertyBinding(){

                public String read() {
                    return EndpointInterfaceResource.this.getDisplayNameTypeString();
                }

                public void write(String value) {
                    EndpointInterfaceResource.this.setDisplayNameTypeString(value);
                }
            };
        }
        if (p == IEndpointInterface.PROP_ASYNC_MAPPING_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return EndpointInterfaceResource.this.asyncMapping.read();
                }

                public void write(String value) {
                    EndpointInterfaceResource.this.asyncMapping.setValue((Object)value);
                }
            };
        }
        if (p == IEndpointInterface.PROP_INTERFACE_JAVADOC) {
            return new ValuePropertyBinding(){

                public String read() {
                    return EndpointInterfaceResource.this.javaDoc.read();
                }

                public void write(String value) {
                    EndpointInterfaceResource.this.javaDoc.setValue((Object)value);
                }
            };
        }
        if (p == IEndpointInterface.PROP_INTERFACE_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return EndpointInterfaceResource.this.interfaceName.read();
                }

                public void write(String value) {
                    EndpointInterfaceResource.this.interfaceName.setValue((Object)value);
                }
            };
        }
        if (p == IEndpointInterface.PROP_PORT_TYPE_NAME) {
            return new ValuePropertyBinding(){

                public String read() {
                    return EndpointInterfaceResource.this.portTypeName.read();
                }

                public void write(String value) {
                    EndpointInterfaceResource.this.portTypeName.setValue((Object)value);
                }
            };
        }
        if (p == IEndpointInterface.PROP_WRAPPER_STYLE_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return EndpointInterfaceResource.this.wrapperStyle.read();
                }

                public void write(String value) {
                    EndpointInterfaceResource.this.wrapperStyle.setValue((Object)value);
                }
            };
        }
        return null;
    }

    @Override
    protected ValueProperty getJavaNameValueProperty() {
        return IEndpointInterface.PROP_INTERFACE_NAME;
    }

    @Override
    protected ValueProperty getWSDLNameValueProperty() {
        return IEndpointInterface.PROP_PORT_TYPE_NAME;
    }
}

