/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.variables;

import java.util.Arrays;
import java.util.List;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.completion.proposal.VariableProposalProcessor;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceJavaVariable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;

public final class WebServiceVariableFactory {
    public static void associateMasterVariables(TemplateVariable[] variables) {
        List<TemplateVariable> potentialDependentVariables = Arrays.asList(variables);
        TemplateVariable[] templateVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable variable = templateVariableArray[n2];
            if (variable instanceof WebServiceJavaVariable) {
                WebServiceJavaVariable masterVariable = (WebServiceJavaVariable)variable;
                for (TemplateVariable tempVar : potentialDependentVariables) {
                    if (!(tempVar instanceof WebServiceJavaVariable)) continue;
                    WebServiceJavaVariable dependentVariable = (WebServiceJavaVariable)tempVar;
                    if (!masterVariable.getName().equals(dependentVariable.getDependentVariableName()) || !dependentVariable.isDependentVariableType(masterVariable.getVariableType().getName())) continue;
                    dependentVariable.setMasterVariable(masterVariable);
                }
            }
            ++n2;
        }
    }

    public static VariableProposalProcessor constructVariableProposalProcessor(TemplateVariable variable, TemplateVariable[] variables, Position position) {
        VariableProposalProcessor variableProposalProcessor = new VariableProposalProcessor(variable, position);
        if (variable instanceof WebServiceJavaVariable) {
            WebServiceJavaVariable masterVariable = (WebServiceJavaVariable)variable;
            List<TemplateVariable> collection = Arrays.asList(variables);
            for (TemplateVariable tempVar : collection) {
                if (!(tempVar instanceof WebServiceJavaVariable)) continue;
                WebServiceJavaVariable dependentVariable = (WebServiceJavaVariable)tempVar;
                if (!masterVariable.getName().equals(dependentVariable.getDependentVariableName()) || !dependentVariable.isDependentVariableType(masterVariable.getVariableType().getName())) continue;
                variableProposalProcessor.addProposalAppliedListener(dependentVariable);
            }
        }
        return variableProposalProcessor;
    }

    public static enum WebServiceVariableType {
        CLASS_TYPE("classType", Messages.template_class_type_proposal_info, -1, false),
        LOCAL_CLASS_TYPE("localClassType", Messages.template_local_class_type_proposal_info, -1, false),
        FIELD_DECLARATION("fieldDeclaration", Messages.template_field_declaration_proposal_info, -1, false),
        ANNOTATED_METHOD("annotatedMethod", Messages.template_annotated_method_proposal_info, 1, true),
        METHOD_DEPENDENT_RETURN_TYPE("methodDependentReturnType", Messages.template_method_dependent_return_type_proposal_info, 2, true),
        METHOD_DEPENDENT_PARAMETER("methodDependentParameter", Messages.template_method_dependent_parameter_proposal_info, 2, true),
        CLASS_DEPENDENT_ANNOTATED_METHOD("classDependentAnnotatedMethod", Messages.template_class_dependent_annotated_method_proposal_info, 3, true),
        CLASS_TYPE_IMPORT("classImport", Messages.template_class_type_import_proposal_info, -1, true),
        RETURN_TYPE_IMPORT("returnTypeImport", Messages.template_return_type_import_proposal_info, -1, true),
        SPECIFIED_IMPORT("specifiedImport", Messages.template_specified_import_proposal_info, -1, false),
        UNIQUE_NAME("uniqueName", Messages.template_unique_name_proposal_info, -1, false),
        DEFAULT("", "", 4, false);

        private final String name;
        private final String description;
        private final int sequence;
        private final boolean isDependent;

        private WebServiceVariableType(String name, String description, int sequence, boolean isDependent) {
            this.name = name;
            this.description = description;
            this.sequence = sequence;
            this.isDependent = isDependent;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public int getSequence() {
            return this.sequence;
        }

        public boolean isDependent() {
            return this.isDependent;
        }

        public TemplateVariable createTemplateVariable(TemplateVariableType type, String name, TemplateContext context, int[] offsets) {
            switch (this) {
                case CLASS_TYPE: {
                    return new WebServiceJavaVariable(type, name, name, context, offsets);
                }
                case LOCAL_CLASS_TYPE: {
                    return new WebServiceJavaVariable(type, name, name, context, offsets);
                }
                case FIELD_DECLARATION: {
                    return new WebServiceJavaVariable(type, name, name, context, offsets);
                }
                case ANNOTATED_METHOD: {
                    WebServiceJavaVariable variable = new WebServiceJavaVariable(type, name, name, context, offsets);
                    variable.addDependentVariableType(CLASS_TYPE.getName());
                    variable.addDependentVariableType(LOCAL_CLASS_TYPE.getName());
                    variable.addDependentVariableType(FIELD_DECLARATION.getName());
                    return variable;
                }
                case METHOD_DEPENDENT_RETURN_TYPE: {
                    WebServiceJavaVariable variable = new WebServiceJavaVariable(type, name, name, context, offsets);
                    variable.addDependentVariableType(ANNOTATED_METHOD.getName());
                    return variable;
                }
                case METHOD_DEPENDENT_PARAMETER: {
                    WebServiceJavaVariable variable = new WebServiceJavaVariable(type, name, name, context, offsets);
                    variable.addDependentVariableType(ANNOTATED_METHOD.getName());
                    return variable;
                }
                case CLASS_DEPENDENT_ANNOTATED_METHOD: {
                    WebServiceJavaVariable variable = new WebServiceJavaVariable(type, name, name, context, offsets);
                    variable.addDependentVariableType(METHOD_DEPENDENT_RETURN_TYPE.getName());
                    return variable;
                }
                case CLASS_TYPE_IMPORT: {
                    WebServiceJavaVariable variable = new WebServiceJavaVariable(type, name, name, context, offsets);
                    variable.addDependentVariableType(CLASS_TYPE.getName());
                    return variable;
                }
                case RETURN_TYPE_IMPORT: {
                    WebServiceJavaVariable variable = new WebServiceJavaVariable(type, name, name, context, offsets);
                    variable.addDependentVariableType(METHOD_DEPENDENT_RETURN_TYPE.getName());
                    return variable;
                }
                case SPECIFIED_IMPORT: {
                    return new TemplateVariable(type, name, name, offsets);
                }
            }
            return new TemplateVariable(type, name, name, offsets);
        }

        public static WebServiceVariableType getVariableType(TemplateVariableType type) {
            if (type != null) {
                WebServiceVariableType[] webServiceVariableTypeArray = WebServiceVariableType.values();
                int n = webServiceVariableTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WebServiceVariableType wsVar = webServiceVariableTypeArray[n2];
                    if (wsVar.getName().equals(type.getName())) {
                        return wsVar;
                    }
                    ++n2;
                }
            }
            return DEFAULT;
        }
    }
}

