/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.variables;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class WebServiceMethod {
    public static final String WEB_METHOD_ANNOTATION = "javax.jws.WebMethod";
    public static final String WEB_ENDPOINT_ANNOTATION = "javax.xml.ws.WebEndpoint";
    private final IMethod method;

    public WebServiceMethod(IMethod method) {
        this.method = method;
    }

    public String methodName() {
        return this.method.getElementName();
    }

    public String returnType() throws IllegalArgumentException, JavaModelException {
        return Signature.getSignatureSimpleName((String)this.method.getReturnType());
    }

    public String methodRawSignature() throws JavaModelException {
        return this.method.getSignature();
    }

    public String methodSignature() throws JavaModelException {
        return Signature.toString((String)this.method.getSignature(), (String)this.method.getElementName(), (String[])this.method.getParameterNames(), (boolean)false, (boolean)false);
    }

    public String methodParameters() throws IllegalArgumentException, JavaModelException {
        String[] params = this.method.getParameterNames();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = params.length;
        while (i < max) {
            buffer.append(params[i]);
            if (i != params.length - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
        return buffer.toString();
    }

    public String methodNameParameterNames() throws IllegalArgumentException, JavaModelException {
        return String.valueOf(this.methodName()) + "(" + this.methodParameters() + ")";
    }
}

