/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.context.WebServiceJavaContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceVariableFactory;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.MemberVariableContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;

public class FieldDeclarationResolver
extends TemplateVariableResolver {
    public FieldDeclarationResolver(WebServiceVariableFactory.WebServiceVariableType variableType) {
        super(variableType.getName(), variableType.getDescription());
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        variable.setUnambiguous(true);
        if (context instanceof WebServiceJavaContext) {
            HashMap<String, IMember> elementNames = new HashMap<String, IMember>();
            String qualifiedTypeName = this.getQualifiedTypeParameter(variable);
            if (qualifiedTypeName != null) {
                MemberVariableContext memberVariableContext = new MemberVariableContext(variable);
                List<IMember> members = ((WebServiceJavaContext)context).javaTypeAllSearchScope(qualifiedTypeName);
                IType memberType = null;
                String qualifiedMemberName = null;
                if (members.size() > 1) {
                    for (IMember member : members) {
                        elementNames.put(member.getElementName(), member);
                    }
                    String[] choices = elementNames.keySet().toArray(new String[elementNames.size()]);
                    qualifiedMemberName = ((WebServiceJavaContext)context).launchSelectionDialog(choices);
                    memberType = (IType)elementNames.get(qualifiedMemberName);
                } else if (members.size() == 1) {
                    IMember member;
                    member = members.get(0);
                    elementNames.put(member.getElementName(), member);
                    memberType = (IType)member;
                    qualifiedMemberName = member.getElementName();
                }
                if (memberType != null) {
                    try {
                        ((WebServiceJavaContext)context).addImportAST(memberType.getFullyQualifiedParameterizedName());
                    }
                    catch (JavaModelException e) {
                        LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                    }
                    String variableName = ((WebServiceJavaContext)context).addFieldDeclarationAST(qualifiedMemberName, this.getParameterAnnotations(variable));
                    if (variableName != null) {
                        variable.setValue(variableName);
                        memberVariableContext.add(variableName, (IMember)elementNames.get(qualifiedMemberName));
                    }
                }
            }
        }
    }

    private String getQualifiedTypeParameter(TemplateVariable variable) {
        String type;
        List params = variable.getVariableType().getParams();
        if (params.size() > 0 && (type = (String)params.get(0)).indexOf(46) != -1) {
            return type;
        }
        return null;
    }

    private List<String> getParameterAnnotations(TemplateVariable variable) {
        List params = variable.getVariableType().getParams();
        ArrayList<String> annotations = new ArrayList<String>();
        if (params.size() > 0) {
            int i = 1;
            while (params.size() > i) {
                annotations.add((String)params.get(i));
                ++i;
            }
        }
        return annotations;
    }
}

