/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.variables;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.context.WebServiceJavaContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.DependentResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceVariableFactory;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.IVariableContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.MethodVariableContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;

public abstract class ClassDependentAnnotatedMethodResolver
extends DependentResolver {
    private String annotation;

    public ClassDependentAnnotatedMethodResolver(String annotation, WebServiceVariableFactory.WebServiceVariableType variableType) {
        super(variableType);
        this.annotation = annotation;
    }

    @Override
    public void resolve(TemplateVariable variable, TemplateContext context) {
        super.resolve(variable, context);
    }

    @Override
    public void dependentResolve(TemplateVariable variable, TemplateContext context) {
        this.appliedResolve(variable, context);
    }

    @Override
    public void appliedResolve(TemplateVariable variable, TemplateContext context) {
        MethodVariableContext methodVariableContext;
        IVariableContext masterVariableContext;
        List<Object> methods = new ArrayList();
        if (context instanceof WebServiceJavaContext && (masterVariableContext = (methodVariableContext = new MethodVariableContext(variable)).getMasterVariableContext()) instanceof MethodVariableContext) {
            WebServiceJavaContext webServiceJavaContext = (WebServiceJavaContext)context;
            List<IMember> members = webServiceJavaContext.javaTypeClassInterfaceApplicationSearchScope(((MethodVariableContext)masterVariableContext).getQualifiedReturnType());
            if (members.size() == 1) {
                try {
                    methods = WebServiceJavaContext.findAnnotatedMethods(this.annotation, members.get(0));
                }
                catch (JavaModelException e) {
                    LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
                }
                for (IMethod method : methods) {
                    methodVariableContext.add(this.getValue(method), method);
                }
            }
            if (methodVariableContext.hasValues()) {
                variable.setValues(methodVariableContext.getKeySetArray());
            }
        }
    }

    public abstract String getValue(IMethod var1);
}

