/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.variables;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.variables.DependentResolver;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceVariableFactory;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.IVariableContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.MemberVariableContext;
import oracle.eclipse.tools.webservices.ui.completion.variables.context.MethodVariableContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;

public abstract class AnnotatedMethodResolver
extends DependentResolver {
    public AnnotatedMethodResolver(WebServiceVariableFactory.WebServiceVariableType variableType) {
        super(variableType);
    }

    @Override
    public void resolve(TemplateVariable variable, TemplateContext context) {
        super.resolve(variable, context);
    }

    @Override
    public void dependentResolve(TemplateVariable variable, TemplateContext context) {
        this.appliedResolve(variable, context);
    }

    @Override
    public void appliedResolve(TemplateVariable variable, TemplateContext context) {
        MethodVariableContext methodVariableContext = new MethodVariableContext(variable);
        IVariableContext masterVariableContext = methodVariableContext.getMasterVariableContext();
        if (masterVariableContext instanceof MemberVariableContext) {
            String qualifiedAnnotationType = VariableParamType.ANNOTATION.getVariableParam(variable);
            List<Object> methods = new ArrayList();
            try {
                methods = ((MemberVariableContext)masterVariableContext).findAnnotatedMethods(qualifiedAnnotationType);
            }
            catch (JavaModelException javaModelException) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)javaModelException));
            }
            for (IMethod iMethod : methods) {
                methodVariableContext.add(this.getValue(iMethod), iMethod);
            }
            if (methodVariableContext.hasValues()) {
                variable.setValues(methodVariableContext.getKeySetArray());
            }
        }
    }

    public abstract String getValue(IMethod var1);

    static enum VariableParamType {
        DEPENDENT_VARIABLE(0),
        ANNOTATION(1);

        private int position;

        private VariableParamType(int position) {
            this.position = position;
        }

        public String getVariableParam(TemplateVariable variable) {
            List params = variable.getVariableType().getParams();
            if (params.size() > this.position) {
                return (String)params.get(this.position);
            }
            return null;
        }
    }
}

