/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.proposal;

import oracle.eclipse.tools.webservices.ui.completion.proposal.ProposalAppliedListenerProcessor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class PositionCompletionProposal
implements IJavaCompletionProposal {
    private String displayString;
    private String replacementString;
    private Position replacementPosition;
    private int cursorPosition;
    private Image image;
    private IContextInformation contextInformation;
    private String additionalProposalInfo;
    private ProposalAppliedListenerProcessor proposalProcessor;

    public PositionCompletionProposal(String replacementString, Position replacementPosition, int cursorPosition, ProposalAppliedListenerProcessor processor, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementPosition != null ? 1 : 0) != 0);
        this.replacementString = replacementString;
        this.replacementPosition = replacementPosition;
        this.cursorPosition = cursorPosition;
        this.image = image;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
        this.proposalProcessor = processor;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementPosition.getOffset(), this.replacementPosition.getLength(), this.replacementString);
            this.proposalProcessor.proposalApplied((ICompletionProposal)this);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementPosition.getOffset() + this.cursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        this.apply(viewer.getDocument());
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            String content = document.get(this.replacementPosition.getOffset(), offset - this.replacementPosition.getOffset());
            if (this.replacementString.startsWith(content)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public int getRelevance() {
        return 0;
    }
}

