/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.webservices.ui.completion.variables.ResolverFactory;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceJavaVariable;
import oracle.eclipse.tools.webservices.ui.completion.variables.WebServiceVariableFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class WebServiceTemplateContextType
extends TemplateContextType {
    public void initializeContextTypeResolvers() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        ResolverFactory.createVariableResolvers(this);
    }

    public void resolve(TemplateBuffer buffer, TemplateContext context) throws MalformedTreeException, BadLocationException {
        super.resolve(buffer, context);
        TemplateVariable[] variables = buffer.getVariables();
        WebServiceVariableFactory.associateMasterVariables(variables);
        int j = 0;
        while (j < variables.length) {
            List<RangeMarker> positions = this.variablesToPositions(variables);
            ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>(5);
            int i = 0;
            while (i != variables.length) {
                String newValue = null;
                int initialLength = 0;
                if (variables[i] instanceof WebServiceJavaVariable) {
                    WebServiceJavaVariable variable = (WebServiceJavaVariable)variables[i];
                    initialLength = variable.getCurrentValue().length();
                    variable.resolveDependentVariable();
                    newValue = variable.getCurrentValue();
                } else {
                    newValue = variables[i].getDefaultValue();
                    initialLength = newValue.length();
                }
                int[] offsets = variables[i].getOffsets();
                int k = 0;
                while (k != offsets.length) {
                    edits.add(new ReplaceEdit(offsets[k], initialLength, newValue));
                    ++k;
                }
                ++i;
            }
            Document document = new Document(buffer.getString());
            MultiTextEdit edit = new MultiTextEdit(0, document.getLength());
            edit.addChildren(positions.toArray(new TextEdit[positions.size()]));
            edit.addChildren(edits.toArray(new TextEdit[edits.size()]));
            edit.apply((IDocument)document, 2);
            this.positionsToVariables(positions, variables);
            buffer.setContent(document.get(), variables);
            ++j;
        }
    }

    private List<RangeMarker> variablesToPositions(TemplateVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private void positionsToVariables(List<RangeMarker> positions, TemplateVariable[] variables) {
        Iterator<RangeMarker> iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    public static enum WebServiceContextTypeId {
        CLIENT_METHOD("web-service-client-method"),
        NONE(null);

        private String typeId;

        private WebServiceContextTypeId(String typeId) {
            this.typeId = typeId;
        }

        public String getTypeId() {
            return this.typeId;
        }

        public static WebServiceContextTypeId getWebServiceContextTypeId(String typeId) {
            WebServiceContextTypeId[] webServiceContextTypeIdArray = WebServiceContextTypeId.values();
            int n = webServiceContextTypeIdArray.length;
            int n2 = 0;
            while (n2 < n) {
                WebServiceContextTypeId wsVar = webServiceContextTypeIdArray[n2];
                if (wsVar.getTypeId().equals(typeId)) {
                    return wsVar;
                }
                ++n2;
            }
            return NONE;
        }

        public static WebServiceContextTypeId getWebServiceContextIdForNodeType(ASTNode node) {
            if (node == null) {
                return NONE;
            }
            int nodeType = node.getNodeType();
            switch (nodeType) {
                case 81: {
                    return NONE;
                }
                case 82: {
                    return NONE;
                }
                case 1: {
                    return NONE;
                }
                case 7: {
                    return NONE;
                }
                case 8: {
                    if (node.getParent() instanceof MethodDeclaration) {
                        return CLIENT_METHOD;
                    }
                    return WebServiceContextTypeId.getWebServiceContextIdForNodeType(node.getParent());
                }
                case 10: {
                    return NONE;
                }
                case 12: {
                    return NONE;
                }
                case 13: {
                    return NONE;
                }
                case 14: {
                    return NONE;
                }
                case 15: {
                    return NONE;
                }
                case 16: {
                    return NONE;
                }
                case 17: {
                    return NONE;
                }
                case 18: {
                    return NONE;
                }
                case 19: {
                    return NONE;
                }
                case 20: {
                    return NONE;
                }
                case 70: {
                    return NONE;
                }
                case 72: {
                    return NONE;
                }
                case 71: {
                    return NONE;
                }
                case 21: {
                    return NONE;
                }
                case 22: {
                    return NONE;
                }
                case 23: {
                    return NONE;
                }
                case 24: {
                    return WebServiceContextTypeId.getWebServiceContextIdForNodeType(node.getParent());
                }
                case 25: {
                    return WebServiceContextTypeId.getWebServiceContextIdForNodeType(node.getParent());
                }
                case 26: {
                    return NONE;
                }
                case 27: {
                    return NONE;
                }
                case 28: {
                    return NONE;
                }
                case 62: {
                    return NONE;
                }
                case 30: {
                    return NONE;
                }
                case 63: {
                    return NONE;
                }
                case 78: {
                    return NONE;
                }
                case 67: {
                    return NONE;
                }
                case 80: {
                    return NONE;
                }
                case 31: {
                    return NONE;
                }
                case 32: {
                    return NONE;
                }
                case 68: {
                    return NONE;
                }
                case 69: {
                    return NONE;
                }
                case 83: {
                    return NONE;
                }
                case 77: {
                    return NONE;
                }
                case 33: {
                    return NONE;
                }
                case 34: {
                    return NONE;
                }
                case 35: {
                    return NONE;
                }
                case 74: {
                    return NONE;
                }
                case 36: {
                    return NONE;
                }
                case 37: {
                    return NONE;
                }
                case 38: {
                    return NONE;
                }
                case 39: {
                    return NONE;
                }
                case 40: {
                    return NONE;
                }
                case 75: {
                    return NONE;
                }
                case 41: {
                    return NONE;
                }
                case 42: {
                    return NONE;
                }
                case 43: {
                    return NONE;
                }
                case 79: {
                    return NONE;
                }
                case 44: {
                    return NONE;
                }
                case 45: {
                    return NONE;
                }
                case 46: {
                    return NONE;
                }
                case 47: {
                    return NONE;
                }
                case 48: {
                    return NONE;
                }
                case 49: {
                    return NONE;
                }
                case 50: {
                    return NONE;
                }
                case 51: {
                    return NONE;
                }
                case 65: {
                    return NONE;
                }
                case 66: {
                    return NONE;
                }
                case 52: {
                    return NONE;
                }
                case 53: {
                    return NONE;
                }
                case 54: {
                    return WebServiceContextTypeId.getWebServiceContextIdForNodeType(node.getParent());
                }
                case 55: {
                    return NONE;
                }
                case 56: {
                    return NONE;
                }
                case 57: {
                    return NONE;
                }
                case 73: {
                    return NONE;
                }
                case 58: {
                    return NONE;
                }
                case 59: {
                    return NONE;
                }
                case 60: {
                    return NONE;
                }
                case 61: {
                    return WebServiceContextTypeId.getWebServiceContextIdForNodeType(node.getParent());
                }
                case 76: {
                    return NONE;
                }
            }
            return NONE;
        }
    }
}

