/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TemplateFormatter {
    private static final String CATEGORY = "__webservice_variables";
    private static final String COMMENT_START = "/*-";
    private static final String COMMENT_END = "*/";
    private static final String LINE_COMMENT = "service.get();//";
    private final IJavaProject project;
    private final TemplateBuffer buffer;
    private final IDocument document;
    private final int offset;
    private Document templateDocument;
    private List<Position> positions;

    public TemplateFormatter(IJavaProject project, TemplateBuffer buffer, IDocument document, int offset) {
        this.project = project;
        this.buffer = buffer;
        this.document = document;
        this.offset = offset;
    }

    private void initializeDocument() {
        this.templateDocument = new Document(this.buffer.getString());
        this.templateDocument.addPositionCategory(CATEGORY);
        this.templateDocument.addPositionUpdater((IPositionUpdater)new PositionUpdater(CATEGORY));
    }

    public boolean format() throws BadLocationException, MalformedTreeException, BadPositionCategoryException {
        if (!this.formatInternal(false)) {
            return this.formatInternal(true);
        }
        return true;
    }

    private boolean formatInternal(boolean commentOutLines) throws BadLocationException, MalformedTreeException, BadPositionCategoryException {
        this.initializeDocument();
        this.mapVariablePositions(commentOutLines);
        Map options = this.project != null ? this.project.getOptions(true) : JavaCore.getOptions();
        String contents = this.templateDocument.get();
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        int[] kinds = nArray;
        TextEdit edit = null;
        int i = 0;
        while (i < kinds.length && edit == null) {
            edit = ToolFactory.createCodeFormatter((Map)options).format(kinds[i], contents, 0, contents.length(), this.getIndentation(), TextUtilities.getDefaultLineDelimiter((IDocument)this.document));
            ++i;
        }
        if (edit == null) {
            return false;
        }
        edit.apply((IDocument)this.templateDocument, 2);
        i = 0;
        while (i != this.templateDocument.getLength() && Character.isWhitespace(this.templateDocument.getChar(i))) {
            ++i;
        }
        this.templateDocument.replace(0, i, "");
        this.applyPositionUpdatesToVariables();
        if (this.templateDocument != null) {
            TemplateVariable[] variables = this.buffer.getVariables();
            this.buffer.setContent(this.templateDocument.get(), variables);
        }
        this.templateDocument = null;
        return true;
    }

    private int getIndentation() {
        try {
            IRegion region = this.document.getLineInformationOfOffset(this.offset);
            String lineContent = this.document.get(region.getOffset(), region.getLength());
            return IndentManipulation.measureIndentUnits((CharSequence)lineContent, (int)this.getTabWidth(this.project), (int)this.getIndentWidth(this.project));
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    private void mapVariablePositions(boolean commentOutLines) throws MalformedTreeException, BadLocationException {
        HashMap<ReplaceEdit, String> markerToOriginal = new HashMap<ReplaceEdit, String>();
        MultiTextEdit root = new MultiTextEdit(0, this.templateDocument.getLength());
        ArrayList<Object> edits = new ArrayList<Object>();
        boolean hasModifications = false;
        TemplateVariable[] variables = this.buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplateVariable templateVariable = variables[i];
            int[] offsets = templateVariable.getOffsets();
            String value = templateVariable.getDefaultValue();
            if (this.isWhitespaceVariable(value)) {
                String placeholder = COMMENT_START + value + COMMENT_END;
                int j = 0;
                while (j != offsets.length) {
                    ReplaceEdit replace = new ReplaceEdit(offsets[j], value.length(), placeholder);
                    root.addChild((TextEdit)replace);
                    hasModifications = true;
                    markerToOriginal.put(replace, value);
                    edits.add(replace);
                    ++j;
                }
            } else {
                int j = 0;
                while (j != offsets.length) {
                    RangeMarker marker = new RangeMarker(offsets[j], value.length());
                    root.addChild((TextEdit)marker);
                    edits.add(marker);
                    ++j;
                }
            }
            ++i;
        }
        if (commentOutLines) {
            int x = 0;
            while (x < this.templateDocument.getNumberOfLines()) {
                int n = this.templateDocument.getLineOffset(x);
                int length = this.templateDocument.getLineLength(x);
                if (length > 0) {
                    ReplaceEdit replace = new ReplaceEdit(n, 0, LINE_COMMENT);
                    root.addChild((TextEdit)replace);
                    hasModifications = true;
                    markerToOriginal.put(replace, "");
                    edits.add(replace);
                }
                ++x;
            }
        }
        if (hasModifications) {
            root.apply((IDocument)this.templateDocument, 2);
        }
        this.positions = new ArrayList<Position>();
        for (TextEdit textEdit : edits) {
            try {
                TypedPosition pos = new TypedPosition(textEdit.getOffset(), textEdit.getLength(), (String)markerToOriginal.get(textEdit));
                this.templateDocument.addPosition(CATEGORY, (Position)pos);
                this.positions.add((Position)pos);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
        }
    }

    private boolean isWhitespaceVariable(String value) {
        int length = value.length();
        return length == 0 || Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(length - 1));
    }

    private int getTabWidth(IJavaProject project) {
        String key = "space".equals(this.getJavaCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return this.getJavaCoreOption(project, key, 4);
    }

    private int getIndentWidth(IJavaProject project) {
        String key = "mixed".equals(this.getJavaCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return this.getJavaCoreOption(project, key, 4);
    }

    private int getJavaCoreOption(IJavaProject project, String key, int def) {
        try {
            return Integer.parseInt(this.getJavaCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private String getJavaCoreOption(IJavaProject project, String key) {
        if (project == null) {
            return JavaCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private void applyPositionUpdatesToVariables() throws MalformedTreeException, BadLocationException, BadPositionCategoryException {
        for (TypedPosition typedPosition : this.positions) {
            this.templateDocument.removePosition(CATEGORY, (Position)typedPosition);
            String original = typedPosition.getType();
            if (original != null) {
                this.templateDocument.replace(typedPosition.getOffset(), typedPosition.getLength(), original);
                typedPosition.setLength(original.length());
            }
            this.templateDocument.addPosition((Position)typedPosition);
        }
        Iterator<Position> it = this.positions.iterator();
        TemplateVariable[] templateVariableArray = this.buffer.getVariables();
        int i = 0;
        while (i != templateVariableArray.length) {
            TemplateVariable variable = templateVariableArray[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = it.next().getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    private static final class PositionUpdater
    implements IPositionUpdater {
        private final String category;

        public PositionUpdater(String category) {
            this.category = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.category);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.category;
        }
    }
}

