/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion.context;

import oracle.eclipse.tools.common.util.ast.EditUtil;
import oracle.eclipse.tools.common.util.ast.IBodyDeclarationInserter;
import oracle.eclipse.tools.common.util.ast.ReaderUtil;
import oracle.eclipse.tools.common.util.ast.WriterContext;
import oracle.eclipse.tools.common.util.ast.WriterUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.completion.context.OffsetBasedNodeLocator;
import oracle.eclipse.tools.webservices.ui.completion.context.internal.EditState;
import oracle.eclipse.tools.webservices.ui.completion.context.internal.EndEditState;
import oracle.eclipse.tools.webservices.ui.completion.context.internal.StartEditState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ASTInvocationContext {
    private final ICompilationUnit compilationUnit;
    private IDocument document;
    private int startingOffset;
    private int length;
    private WriterContext writerContext = null;
    private TypeDeclaration typeDeclaration = null;
    private EditState startEditState;
    private EditState endEditState;
    private EditState currentEditState;

    public ASTInvocationContext(ICompilationUnit compilationUnit, IDocument document, int startingOffset, int length) {
        this.compilationUnit = compilationUnit;
        this.document = document;
        this.startingOffset = startingOffset;
        this.length = length;
        this.initializeEditState();
    }

    private void initializeEditState() {
        this.endEditState = new EndEditState(this);
        this.startEditState = new StartEditState(this);
        this.currentEditState = this.endEditState;
    }

    public ASTNode findContainingNode() {
        OffsetBasedNodeLocator offsetNodeVisitor = new OffsetBasedNodeLocator(this.startingOffset, this.length);
        this.getASTRoot().accept((ASTVisitor)offsetNodeVisitor);
        ASTNode containingNode = offsetNodeVisitor.getContainingNode();
        if (containingNode != null) {
            return containingNode;
        }
        return null;
    }

    public CompilationUnit getASTRoot() {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(this.compilationUnit);
        parser.setResolveBindings(false);
        CompilationUnit unitAST = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
        return unitAST;
    }

    public boolean doNodesIntersect(ASTNode firstNode, ASTNode secondNode) {
        if (this.isContainingNode(firstNode, secondNode)) {
            return true;
        }
        return this.isContainingNode(secondNode, firstNode);
    }

    public boolean isContainingNode(ASTNode containingNode, ASTNode node) {
        if (containingNode != null && node != null) {
            if (containingNode.subtreeMatch(new ASTMatcher(), (Object)node)) {
                return true;
            }
            return this.isContainingNode(containingNode, node.getParent());
        }
        return false;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public void setStartingOffset(int startingOffset) {
        this.startingOffset = startingOffset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void insertFieldDeclaration(FieldDeclaration fieldDeclaration) {
        this.currentEditState.startEdit();
        try {
            WriterUtil.insertDeclaration((TypeDeclaration)this.typeDeclaration, (ASTNode)fieldDeclaration, (IBodyDeclarationInserter)new IBodyDeclarationInserter.FieldInserter(), (WriterContext)this.writerContext);
        }
        catch (BadLocationException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
    }

    public void addImport(String type) {
        this.currentEditState.startEdit();
        WriterUtil.ensureImport((ASTNode)this.typeDeclaration, (String)type, (WriterContext)this.writerContext);
    }

    public void commitRewrite() {
        this.currentEditState.commitEdit();
        this.currentEditState.endEdit();
    }

    public void internalEndEdit() {
        if (this.hasEditContext()) {
            try {
                EditUtil.endEdit((WriterContext)this.writerContext);
            }
            catch (JavaModelException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)e));
            }
            catch (BadLocationException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            }
            catch (CoreException e) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
            }
        }
    }

    public void initializeEditContext() {
        try {
            this.setCurrentEditState(this.getStartEditState());
            this.writerContext = EditUtil.startEdit((ICompilationUnit)this.compilationUnit);
            this.typeDeclaration = ReaderUtil.getPrimaryType((CompilationUnit)this.writerContext.getCompilationUnit());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)e);
        }
    }

    public void nullEditContext() {
        this.writerContext = null;
        this.typeDeclaration = null;
    }

    public boolean hasEditContext() {
        return this.writerContext != null && this.typeDeclaration != null;
    }

    public EditState getStartEditState() {
        return this.startEditState;
    }

    public EditState getEndEditState() {
        return this.endEditState;
    }

    public void setCurrentEditState(EditState currentEditState) {
        this.currentEditState = currentEditState;
    }

    public WriterContext getWriterContext() {
        return this.writerContext;
    }
}

