/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.completion;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ProposalInfoFormatter {
    private static RGB BG_COLOR_RGB;
    private static RGB FG_COLOR_RGB;

    static {
        block3: {
            BG_COLOR_RGB = new RGB(255, 255, 225);
            FG_COLOR_RGB = new RGB(0, 0, 0);
            final Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                try {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BG_COLOR_RGB = display.getSystemColor(29).getRGB();
                            FG_COLOR_RGB = display.getSystemColor(28).getRGB();
                        }
                    });
                }
                catch (SWTError err) {
                    if (err.code == 45) break block3;
                    throw err;
                }
            }
        }
    }

    private ProposalInfoFormatter() {
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        while (current > -1) {
            builder.append(text.substring(previous, current));
            builder.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        builder.append(text.substring(previous));
        return builder.toString();
    }

    public static String convertToHTMLContent(String content) {
        content = ProposalInfoFormatter.replace(content, '&', "&amp;");
        content = ProposalInfoFormatter.replace(content, '\"', "&quot;");
        content = ProposalInfoFormatter.replace(content, '<', "&lt;");
        return ProposalInfoFormatter.replace(content, '>', "&gt;");
    }

    public static String read(Reader rd) {
        StringBuilder builder = new StringBuilder();
        char[] readbuilder = new char[2048];
        try {
            int n = rd.read(readbuilder);
            while (n > 0) {
                builder.append(readbuilder, 0, n);
                n = rd.read(readbuilder);
            }
            return builder.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuilder builder, int position, RGB fgRGB, RGB bgRGB, String styleSheet) {
        if (fgRGB == null) {
            fgRGB = FG_COLOR_RGB;
        }
        if (bgRGB == null) {
            bgRGB = BG_COLOR_RGB;
        }
        StringBuilder pageProlog = new StringBuilder(300);
        pageProlog.append("<html>");
        ProposalInfoFormatter.appendStyleSheetURL(pageProlog, styleSheet);
        ProposalInfoFormatter.appendColors(pageProlog, fgRGB, bgRGB);
        builder.insert(position, pageProlog.toString());
    }

    private static void appendColors(StringBuilder pageProlog, RGB fgRGB, RGB bgRGB) {
        pageProlog.append("<body text=\"");
        ProposalInfoFormatter.appendColor(pageProlog, fgRGB);
        pageProlog.append("\" bgcolor=\"");
        ProposalInfoFormatter.appendColor(pageProlog, bgRGB);
        pageProlog.append("\">");
    }

    private static void appendColor(StringBuilder builder, RGB rgb) {
        builder.append('#');
        ProposalInfoFormatter.appendAsHexString(builder, rgb.red);
        ProposalInfoFormatter.appendAsHexString(builder, rgb.green);
        ProposalInfoFormatter.appendAsHexString(builder, rgb.blue);
    }

    private static void appendAsHexString(StringBuilder builder, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            builder.append('0');
        }
        builder.append(hexValue);
    }

    public static void insertStyles(StringBuilder builder, String[] styles) {
        if (styles == null || styles.length == 0) {
            return;
        }
        StringBuilder styleBuf = new StringBuilder(10 * styles.length);
        int i = 0;
        while (i < styles.length) {
            styleBuf.append(" style=\"");
            styleBuf.append(styles[i]);
            styleBuf.append('\"');
            ++i;
        }
        int index = builder.indexOf("<body ");
        if (index != -1) {
            builder.insert(index + 5, styleBuf);
            return;
        }
        index = builder.indexOf("<body>");
        if (index != -1) {
            builder.insert(index + 5, ' ');
            builder.insert(index + 6, styleBuf);
            return;
        }
    }

    private static void appendStyleSheetURL(StringBuilder builder, String styleSheet) {
        if (styleSheet == null) {
            return;
        }
        builder.append("<head><style CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        builder.append(styleSheet);
        builder.append("</style></head>");
    }

    private static void appendStyleSheetURL(StringBuilder builder, URL styleSheetURL) {
        if (styleSheetURL == null) {
            return;
        }
        builder.append("<head>");
        builder.append("<LINK REL=\"stylesheet\" HREF= \"");
        builder.append(styleSheetURL);
        builder.append("\" CHARSET=\"ISO-8859-1\" TYPE=\"text/css\">");
        builder.append("</head>");
    }

    public static void insertPageProlog(StringBuilder builder, int position) {
        StringBuilder pageProlog = new StringBuilder(60);
        pageProlog.append("<html>");
        ProposalInfoFormatter.appendColors(pageProlog, FG_COLOR_RGB, BG_COLOR_RGB);
        builder.insert(position, pageProlog.toString());
    }

    public static void insertPageProlog(StringBuilder builder, int position, URL styleSheetURL) {
        StringBuilder pageProlog = new StringBuilder(300);
        pageProlog.append("<html>");
        ProposalInfoFormatter.appendStyleSheetURL(pageProlog, styleSheetURL);
        ProposalInfoFormatter.appendColors(pageProlog, FG_COLOR_RGB, BG_COLOR_RGB);
        builder.insert(position, pageProlog.toString());
    }

    public static void insertPageProlog(StringBuilder builder, int position, String styleSheet) {
        ProposalInfoFormatter.insertPageProlog(builder, position, null, null, styleSheet);
    }

    public static void addPageProlog(StringBuilder builder) {
        ProposalInfoFormatter.insertPageProlog(builder, builder.length());
    }

    public static void addPageEpilog(StringBuilder builder) {
        builder.append("</body></html>");
    }

    public static void startBulletList(StringBuilder builder) {
        builder.append("<ul>");
    }

    public static void endBulletList(StringBuilder builder) {
        builder.append("</ul>");
    }

    public static void addBullet(StringBuilder builder, String bullet) {
        if (bullet != null) {
            builder.append("<li>");
            builder.append(bullet);
            builder.append("</li>");
        }
    }

    public static void startDefinitionList(StringBuilder builder) {
        builder.append("<dl>");
    }

    public static void endDefinitionList(StringBuilder builder) {
        builder.append("</dl>");
    }

    public static void addDefinition(StringBuilder builder, String term, String definition) {
        if (term != null && definition != null && term.length() > 0 && definition.length() > 0) {
            builder.append("<dt>");
            builder.append(term);
            builder.append("</dt>");
            builder.append("<dd>");
            builder.append(definition);
            builder.append("</dd>");
        }
    }

    public static void addCode(StringBuilder builder, String code) {
        if (code != null && code.length() > 0) {
            builder.append("<code>");
            builder.append(code);
            builder.append("</code>");
        }
    }

    public static void addLineBreak(StringBuilder builder) {
        builder.append("<br>");
    }

    public static void addLargeHeader(StringBuilder builder, String header) {
        if (header != null) {
            builder.append("<h1>");
            builder.append(header);
            builder.append("</h1>");
        }
    }

    public static void addMediumHeader(StringBuilder builder, String header) {
        if (header != null) {
            builder.append("<h3>");
            builder.append(header);
            builder.append("</h3>");
        }
    }

    public static void addSmallHeader(StringBuilder builder, String header) {
        if (header != null) {
            builder.append("<h5>");
            builder.append(header);
            builder.append("</h5>");
        }
    }

    public static void addParagraph(StringBuilder builder, String paragraph) {
        if (paragraph != null) {
            builder.append("<p>");
            builder.append(paragraph);
        }
    }

    public static void addParagraph(StringBuilder builder, Reader paragraphReader) {
        if (paragraphReader != null) {
            ProposalInfoFormatter.addParagraph(builder, ProposalInfoFormatter.read(paragraphReader));
        }
    }

    public static String convertTopLevelFont(String styles, FontData fontData) {
        boolean bold = (fontData.getStyle() & 1) != 0;
        boolean italic = (fontData.getStyle() & 2) != 0;
        String size = String.valueOf(Integer.toString(fontData.getHeight())) + ("carbon".equals(SWT.getPlatform()) ? "px" : "pt");
        String family = "'" + fontData.getName() + "',sans-serif";
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-size:\\s*)\\d+pt(\\;?.*\\})", "$1" + size + "$2");
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-weight:\\s*)\\w+(\\;?.*\\})", "$1" + (bold ? "bold" : "normal") + "$2");
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-style:\\s*)\\w+(\\;?.*\\})", "$1" + (italic ? "italic" : "normal") + "$2");
        styles = styles.replaceFirst("(html\\s*\\{.*(?:\\s|;)font-family:\\s*).+?(;.*\\})", "$1" + family + "$2");
        return styles;
    }
}

