/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.bindings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.eclipse.tools.webservices.ui.bindings.WsdlSelectionComposite;
import org.eclipse.core.runtime.IStatus;

public class WsdlSelectionStatusMonitor {
    private WsdlSelectionComposite wsdlComposite;
    private PropertyChangeListener statusListener;
    private IStatusUpdate statusUpdate;

    public WsdlSelectionStatusMonitor(WsdlSelectionComposite wsdlComposite, IStatusUpdate statusUpdate) {
        this.wsdlComposite = wsdlComposite;
        this.statusUpdate = statusUpdate;
        this.statusListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WsdlSelectionStatusMonitor.this.updateStatus();
            }
        };
        this.updateStatus();
    }

    public void start() {
        this.wsdlComposite.addListener("STATUS", this.statusListener);
    }

    public void stop() {
        this.wsdlComposite.removeListener("STATUS", this.statusListener);
    }

    private void updateStatus() {
        IStatus status = this.wsdlComposite.getStatus();
        int severity = status.getSeverity();
        String message = status.getMessage();
        this.updateMessage(severity, message);
        this.updateComplete(severity);
    }

    private void updateMessage(int severity, String message) {
        if ("".equals(message)) {
            message = null;
        }
        if (severity != 4) {
            this.statusUpdate.setErrorMessage(null);
        }
        switch (severity) {
            case 0: {
                this.statusUpdate.setMessage(null, 0);
                break;
            }
            case 1: {
                this.statusUpdate.setMessage(message, 1);
                break;
            }
            case 2: {
                this.statusUpdate.setMessage(message, 2);
                break;
            }
            case 4: {
                this.statusUpdate.setErrorMessage(message);
                break;
            }
        }
    }

    private void updateComplete(int severity) {
        this.statusUpdate.setComplete(severity != 4);
    }

    public static interface IStatusUpdate {
        public void setMessage(String var1, int var2);

        public void setErrorMessage(String var1);

        public void setComplete(boolean var1);
    }
}

