/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.bindings;

import java.net.URI;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.bindings.WsdlSelectionComposite;
import oracle.eclipse.tools.webservices.ui.bindings.WsdlSelectionStatusMonitor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class WsdlSelectionDialog
extends TitleAreaDialog {
    private WsdlSelectionStatusMonitor statusMonitor;
    private WsdlSelectionComposite wsdlComposite;
    private IProject project;

    public WsdlSelectionDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    public boolean close() {
        this.statusMonitor.stop();
        return super.close();
    }

    public Control createDialogArea(Composite parent) {
        this.wsdlComposite = new WsdlSelectionComposite(parent, 0, this.project);
        return this.wsdlComposite;
    }

    public URI getWsdlUri() {
        if (this.wsdlComposite != null) {
            return this.wsdlComposite.getWsdlUri();
        }
        return null;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(Messages.wsdl_location_page_description);
        this.statusMonitor = new WsdlSelectionStatusMonitor(this.wsdlComposite, new WsdlSelectionStatusMonitor.IStatusUpdate(){

            @Override
            public void setComplete(boolean complete) {
                Button okButton = WsdlSelectionDialog.this.getButton(0);
                if (okButton != null && !okButton.isDisposed()) {
                    okButton.setEnabled(complete);
                }
            }

            @Override
            public void setErrorMessage(String message) {
                WsdlSelectionDialog.this.setErrorMessage(message);
            }

            @Override
            public void setMessage(String message, int type) {
                WsdlSelectionDialog.this.setMessage(message, type);
            }
        });
        this.statusMonitor.start();
        return contents;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.wsdl_location_page_title);
    }

    protected boolean isResizable() {
        return true;
    }
}

