/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.bindings;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import oracle.eclipse.tools.webservices.model.WsdlModelValidator;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.wizards.common.IFileSelectionChangedListener;
import oracle.eclipse.tools.webservices.ui.wizards.common.TableOfWsdFilesLocationGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WsdlSelectionComposite
extends Composite {
    public static final String STATUS = "STATUS";
    public static final String WSDL_TYPE = "WSDL_TYPE";
    public static final String WSDL_URI = "WSDL_URI";
    private IStatus status;
    private WsdlType wsdlType;
    private URI wsdlURI;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private Composite localComposite;
    private Composite remoteComposite;
    private Text urlText;
    private TableOfWsdFilesLocationGroup tableOfFilesLocationGroup;
    private PropertyChangeSupport support = new PropertyChangeSupport((Object)this);

    public WsdlSelectionComposite(Composite parent, int style, IProject project) {
        super(parent, style);
        GridData data = new GridData(1808);
        data.horizontalIndent = 0;
        data.verticalIndent = 0;
        this.setLayoutData(data);
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.createMainComposite(this, project);
        this.initialize();
    }

    public IStatus getStatus() {
        return this.status;
    }

    public WsdlType getWsdlType() {
        return WsdlType.LOCAL;
    }

    public URI getWsdlUri() {
        return this.wsdlURI;
    }

    public void updateProject(IProject project) {
        this.tableOfFilesLocationGroup.contentChanged(project);
        this.validate();
    }

    public void addListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    private void createMainComposite(Composite parent, IProject project) {
        this.stackComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 450;
        this.stackComposite.setLayoutData((Object)data);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.createLocalComposite(this.stackComposite, project);
        this.createRemoteComposite(this.stackComposite);
    }

    private void createLocationSelectionComposite(Composite parent) {
        Composite selectionComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 10;
        GridData gridData = new GridData();
        selectionComposite.setLayout((Layout)gridLayout);
        selectionComposite.setLayoutData((Object)gridData);
        Label locationLabel = new Label(selectionComposite, 0);
        locationLabel.setText(Messages.wsdl_location_page_with_remote_choice_wsdl_location);
        Button localButton = new Button(selectionComposite, 16);
        localButton.setText(Messages.wsdl_location_page_with_remote_choice_local);
        localButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WsdlSelectionComposite.this.updateWsdlType();
            }
        });
        localButton.setSelection(true);
    }

    private void createLocalComposite(Composite parent, IProject project) {
        this.localComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.marginTop = 10;
        gridLayout.marginBottom = 10;
        this.localComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.localComposite.setLayoutData((Object)gridData);
        this.tableOfFilesLocationGroup = new TableOfWsdFilesLocationGroup(project);
        this.tableOfFilesLocationGroup.createControl(this.localComposite);
        this.tableOfFilesLocationGroup.addWsdlSelectionChangedListener(new IFileSelectionChangedListener(){

            @Override
            public boolean fileSelectionChanged(IStructuredSelection selection, IFile wsdl) {
                WsdlSelectionComposite.this.updateWsdl();
                return true;
            }
        });
    }

    private void createRemoteComposite(Composite parent) {
        this.remoteComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        this.remoteComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.remoteComposite.setLayoutData((Object)gridData);
        new Label(this.remoteComposite, 0).setText(Messages.wsdl_location_page_with_remote_choice_url);
        this.urlText = new Text(this.remoteComposite, 2052);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WsdlSelectionComposite.this.updateWsdl();
            }
        });
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.urlText.setLayoutData((Object)gridData);
    }

    private void initialize() {
        this.updateWsdlType();
        this.updateWsdl();
    }

    private void updateWsdlType() {
        WsdlType type = WsdlType.LOCAL;
        this.setWsdlType(type);
        this.updateWsdl();
        this.updateTopControl();
        this.validate();
    }

    private void updateWsdl() {
        IFile wsdl;
        WsdlType type = this.getWsdlType();
        URI uri = null;
        if (type == WsdlType.REMOTE) {
            try {
                uri = WsdlSelectionComposite.getURI(this.urlText.getText());
            }
            catch (Exception exception) {}
        } else if (type == WsdlType.LOCAL && (wsdl = this.tableOfFilesLocationGroup.getSelectedFile()) != null) {
            uri = wsdl.getLocationURI();
        }
        this.setWsdlUri(uri);
        this.validate();
    }

    private void updateTopControl() {
        WsdlType type = this.getWsdlType();
        Composite composite = this.localComposite;
        if (type == WsdlType.REMOTE) {
            composite = this.remoteComposite;
        }
        this.stackLayout.topControl = composite;
        this.stackComposite.layout();
    }

    private void validate() {
        WsdlType type = this.getWsdlType();
        if (type == WsdlType.REMOTE) {
            this.validateRemoteWsdl();
        } else if (type == WsdlType.LOCAL) {
            this.validateLocalWsdl();
        }
    }

    private void validateLocalWsdl() {
        IFile wsdl = this.tableOfFilesLocationGroup.getSelectedFile();
        if (wsdl == null) {
            this.setErrorStatus();
        } else if (!wsdl.exists()) {
            this.setErrorStatus(Messages.bind((String)Messages.wsdl_model_factory_file_does_not_exist, (Object)wsdl.getProjectRelativePath()));
        } else {
            this.setStatus(WsdlModelValidator.validate((IFile)wsdl));
        }
    }

    private void validateRemoteWsdl() {
        String url = this.urlText.getText();
        if (url == null || "".equals(url)) {
            this.setErrorStatus();
        } else {
            try {
                WsdlSelectionComposite.getURI(url);
                this.setOKStatus();
            }
            catch (MalformedURLException mue) {
                this.setErrorStatus(Messages.bind((String)Messages.wsdl_location_page_with_remote_choice_not_valid_url, (Object)url), mue);
            }
            catch (URISyntaxException use) {
                this.setErrorStatus(Messages.bind((String)Messages.wsdl_model_factory_uri_syntax_error, (Object)use.getInput()), use);
            }
        }
    }

    private void setErrorStatus() {
        this.setErrorStatus(null);
    }

    private void setErrorStatus(String message) {
        this.setErrorStatus(message, null);
    }

    private void setErrorStatus(String message, Throwable t) {
        this.setStatus((IStatus)new Status(4, "oracle.eclipse.tools.webservices.ui", message, t));
    }

    private void setOKStatus() {
        this.setStatus(Status.OK_STATUS);
    }

    private void setStatus(IStatus status) {
        IStatus oldValue = this.status;
        this.status = status;
        this.support.firePropertyChange(STATUS, oldValue, status);
    }

    private void setWsdlType(WsdlType wsdlType) {
        WsdlType oldValue = this.wsdlType;
        this.wsdlType = wsdlType;
        this.support.firePropertyChange(WSDL_TYPE, (Object)oldValue, (Object)this.wsdlType);
    }

    private void setWsdlUri(URI wsdlUri) {
        URI oldValue = this.wsdlURI;
        this.wsdlURI = wsdlUri;
        this.support.firePropertyChange(WSDL_URI, oldValue, this.wsdlURI);
    }

    private static URI getURI(String urlText) throws MalformedURLException, URISyntaxException {
        URL url = new URL(urlText);
        return url.toURI();
    }

    public static enum WsdlType {
        REMOTE,
        LOCAL;

    }
}

