/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.webservices.WebServicesCorePlugin;
import oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.IJwsAnnotation;
import oracle.eclipse.tools.webservices.ui.properties.jws.elements.IAnnotationElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public abstract class JwsAnnotationResource
extends Resource {
    private IAnnotationElement annotationElement;
    private Map<ValueProperty, String> idMap = new HashMap<ValueProperty, String>();

    public JwsAnnotationResource(Resource parent, IAnnotationElement annotationElement) {
        super(parent);
        this.initIdMap(this.idMap);
        this.annotationElement = annotationElement;
        this.addAnnotationElementPropertyChangeListener(this.annotationElement);
    }

    protected abstract void initIdMap(Map<ValueProperty, String> var1);

    protected void addAnnotationElementPropertyChangeListener(IAnnotationElement annotateElement) {
        annotateElement.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JwsAnnotationResource.this.element().refresh();
                    }
                });
            }
        });
    }

    public final IAnnotationElement getAnnotationElement() {
        return this.annotationElement;
    }

    public IRuntime getRuntime() {
        try {
            IAnnotationElement annotationElement = this.getAnnotationElement();
            IFile sourceFile = annotationElement.getSourceFile();
            IProject project = sourceFile.getProject();
            IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
            return RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fp.getPrimaryRuntime());
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)WebServicesCorePlugin.getDefault(), (Throwable)e, (String)"Could not determine project");
            return null;
        }
    }

    public abstract String getId();

    public final boolean isAnnotationSet() {
        return this.annotationElement.isAnnotationSet();
    }

    public final void setAnnotation() {
        this.annotationElement.setAnnotation();
    }

    public final void clearAnnotation() {
        this.annotationElement.clearAnnotation();
    }

    public final IStatus validateValue(ValueProperty property, String value) {
        return this.annotationElement.validateElementValue(this.idMap.get(property), value);
    }

    public final String getDefaultValue(ValueProperty property) {
        return this.annotationElement.getDefaultElementValue(this.idMap.get(property));
    }

    protected PropertyBinding createBinding(Property property) {
        PropertyDef p = property.definition();
        if (p == IJwsAnnotation.PROP_ENABLED) {
            return new ValuePropertyBinding(){

                public String read() {
                    return Boolean.toString(JwsAnnotationResource.this.isAnnotationSet());
                }

                public void write(String value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (p instanceof ValueProperty) {
            ValueProperty vprop = (ValueProperty)p;
            final String identifier = this.idMap.get(vprop);
            final IAnnotationElement annotation = this.getAnnotationElement();
            return new ValuePropertyBinding(){

                public String read() {
                    if (annotation.isElementSet(identifier)) {
                        return annotation.getElementValue(identifier);
                    }
                    return null;
                }

                public void write(String value) {
                    if (value == null) {
                        annotation.clearElement(identifier);
                    } else {
                        annotation.setElementValue(identifier, value);
                    }
                }
            };
        }
        throw new IllegalStateException();
    }

    public <A> A adapt(Class<A> adapterType) {
        if (adapterType == IFile.class) {
            return (A)this.annotationElement.getSourceFile();
        }
        if (adapterType == IProject.class) {
            IFile file = this.annotationElement.getSourceFile();
            if (file != null) {
                return (A)file.getProject();
            }
            return null;
        }
        return (A)super.adapt(adapterType);
    }
}

