/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.annotations.jws.descriptors.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.AddUnimplementedConstructorsAction;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.actions.OverrideMethodsAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeConstraintBehavior;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.PropertyEditorActionHandler;
import org.eclipse.sapphire.ui.forms.PropertyEditorCondition;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public class JWSTypeCreateActionHandler
extends PropertyEditorActionHandler {
    private JavaTypeName base;
    private final List<JavaTypeName> interfaces = new ArrayList<JavaTypeName>();

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        final Element element = this.getModelElement();
        ValueProperty property = (ValueProperty)this.property().definition();
        IProject proj = (IProject)element.adapt(IProject.class);
        IJavaProject jproj = JavaCore.create((IProject)proj);
        JavaTypeConstraint javaTypeConstraintAnnotation = (JavaTypeConstraint)property.getAnnotation(JavaTypeConstraint.class);
        if (javaTypeConstraintAnnotation != null) {
            String[] types = javaTypeConstraintAnnotation.type();
            int i = 0;
            int n = javaTypeConstraintAnnotation.behavior() == JavaTypeConstraintBehavior.ALL ? types.length : Math.min(1, types.length);
            while (i < n) {
                String typeName = types[i];
                try {
                    IType type = jproj.findType(typeName.replace('$', '.'));
                    if (type != null && type.exists()) {
                        if (type.isClass()) {
                            this.base = new JavaTypeName(typeName);
                        } else if (type.isInterface()) {
                            this.interfaces.add(new JavaTypeName(typeName));
                        }
                    }
                }
                catch (Exception e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
                ++i;
            }
        }
        FilteredListener<PropertyEvent> listener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                JWSTypeCreateActionHandler.this.refreshEnablementState();
            }
        };
        element.attach((Listener)listener, property.name());
        this.attach((Listener)new FilteredListener<DisposeEvent>((Listener)listener, property){
            private final /* synthetic */ Listener val$listener;
            private final /* synthetic */ ValueProperty val$property;
            {
                this.val$listener = listener;
                this.val$property = valueProperty;
            }

            protected void handleTypedEvent(DisposeEvent event) {
                element.detach(this.val$listener, this.val$property.name());
            }
        });
    }

    protected Object run(Presentation context) {
        final Element element = this.getModelElement();
        Value javaTypeNameValue = (Value)this.property();
        if (javaTypeNameValue.malformed()) {
            return null;
        }
        final JavaTypeName javaTypeName = (JavaTypeName)javaTypeNameValue.content();
        if (javaTypeName.pkg() == null && !MessageDialog.openConfirm((Shell)((SwtPresentation)context).shell(), (String)Resources.discourageDialogTitle, (String)Resources.discourageDefaultPackage)) {
            return null;
        }
        if (!Character.isUpperCase(javaTypeName.simple().charAt(0)) && !MessageDialog.openConfirm((Shell)((SwtPresentation)context).shell(), (String)Resources.discourageDialogTitle, (String)Resources.discourageLowerCase)) {
            return null;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", 7);
                JavaTypeKind kind = JWSTypeCreateActionHandler.this.getJavaTypeKind();
                StringBuilder buf = new StringBuilder();
                if (javaTypeName.pkg() != null) {
                    buf.append("package ");
                    buf.append(javaTypeName.pkg());
                    buf.append(";\n\n");
                }
                ArrayList<JavaTypeName> imports = new ArrayList<JavaTypeName>();
                imports.add(javaTypeName);
                String base = null;
                if (kind == JavaTypeKind.CLASS && JWSTypeCreateActionHandler.this.base != null) {
                    base = JWSTypeCreateActionHandler.deriveSafeLocalName(JWSTypeCreateActionHandler.this.base, imports);
                }
                ArrayList<String> interfaces = new ArrayList<String>();
                if (kind == JavaTypeKind.CLASS || kind == JavaTypeKind.INTERFACE) {
                    for (JavaTypeName t : JWSTypeCreateActionHandler.this.interfaces) {
                        interfaces.add(JWSTypeCreateActionHandler.deriveSafeLocalName(t, imports));
                    }
                }
                imports.remove(javaTypeName);
                if (!imports.isEmpty()) {
                    for (JavaTypeName t : imports) {
                        buf.append("import ");
                        buf.append(t.qualified().replace('$', '.'));
                        buf.append(";\n");
                    }
                    buf.append('\n');
                }
                JWSTypeCreateActionHandler.this.addImports(buf);
                JWSTypeCreateActionHandler.this.addClassAnnotation(buf);
                buf.append("public ");
                switch (kind) {
                    case ANNOTATION: {
                        buf.append("@interface");
                        break;
                    }
                    case ENUM: {
                        buf.append("enum");
                        break;
                    }
                    case INTERFACE: {
                        buf.append("interface");
                        break;
                    }
                    default: {
                        buf.append("class");
                    }
                }
                buf.append(' ');
                buf.append(javaTypeName.simple());
                if (base != null) {
                    buf.append(" extends ");
                    buf.append(base);
                }
                if (!interfaces.isEmpty()) {
                    buf.append(kind == JavaTypeKind.INTERFACE ? " extends " : " implements ");
                    boolean first = true;
                    for (String implementsType : interfaces) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(implementsType);
                    }
                }
                buf.append("\n{\n}\n");
                monitor.worked(1);
                IProject proj = (IProject)element.adapt(IProject.class);
                IJavaProject jproj = JavaCore.create((IProject)proj);
                try {
                    IPackageFragmentRoot src = JWSTypeCreateActionHandler.this.src(jproj);
                    IPackageFragment pkg = src.createPackageFragment(javaTypeName.pkg() == null ? "" : javaTypeName.pkg(), true, null);
                    ICompilationUnit cu = pkg.createCompilationUnit(String.valueOf(javaTypeName.simple()) + ".java", buf.toString(), true, null);
                    cu.save(null, true);
                    monitor.worked(1);
                    IEditorPart editor = JavaUI.openInEditor((IJavaElement)cu);
                    IWorkbenchPartSite site = editor.getSite();
                    monitor.worked(1);
                    if (kind == JavaTypeKind.CLASS) {
                        IType type = cu.getType(javaTypeName.simple());
                        ASTParser parser = ASTParser.newParser((int)3);
                        parser.setResolveBindings(true);
                        parser.setSource(cu);
                        CompilationUnit ast = (CompilationUnit)parser.createAST(null);
                        ASTNode node = NodeFinder.perform((ASTNode)ast, (ISourceRange)type.getNameRange());
                        while (!(node instanceof AbstractTypeDeclaration)) {
                            node = node.getParent();
                        }
                        ITypeBinding typeBinding = ((AbstractTypeDeclaration)node).resolveBinding();
                        IWorkspaceRunnable addUnimplementedConstructorsOp = AddUnimplementedConstructorsAction.createRunnable((CompilationUnit)ast, (ITypeBinding)typeBinding, null, (int)-1, (boolean)false, (int)1, (boolean)false);
                        addUnimplementedConstructorsOp.run(null);
                        IWorkspaceRunnable overrideMethodsOp = OverrideMethodsAction.createRunnable((CompilationUnit)ast, (ITypeBinding)typeBinding, null, (int)-1, (boolean)false);
                        overrideMethodsOp.run(null);
                    }
                    monitor.worked(1);
                    OrganizeImportsAction organizeImportsAction = new OrganizeImportsAction((IWorkbenchSite)site);
                    organizeImportsAction.run(cu);
                    monitor.worked(1);
                    FormatAllAction formatAllAction = new FormatAllAction((IWorkbenchSite)site);
                    formatAllAction.runOnMultiple(new ICompilationUnit[]{cu});
                    monitor.worked(1);
                    editor.doSave(null);
                    monitor.worked(1);
                }
                catch (CoreException e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(((SwtPresentation)context).shell()).run(false, false, op);
        }
        catch (InvocationTargetException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        catch (InterruptedException e) {
            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
        }
        return null;
    }

    protected JavaTypeKind getJavaTypeKind() {
        return JavaTypeKind.INTERFACE;
    }

    protected void addImports(StringBuilder buf) {
        buf.append("import javax.jws.WebService;\n");
    }

    protected void addClassAnnotation(StringBuilder buf) {
        buf.append("@WebService\n");
    }

    protected boolean computeEnablementState() {
        boolean enabled = super.computeEnablementState();
        if (enabled) {
            String typeName;
            ReferenceValue ref = (ReferenceValue)this.property();
            enabled = false;
            if (!ref.malformed() && (typeName = ref.text()) != null && typeName.indexOf(36) == -1 && ref.resolve() == null) {
                enabled = true;
            }
        }
        return enabled;
    }

    private final IPackageFragmentRoot src(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root;
            }
            ++n2;
        }
        return null;
    }

    private static String deriveSafeLocalName(JavaTypeName type, Collection<JavaTypeName> imports) {
        boolean collision = false;
        for (JavaTypeName n : imports) {
            if (!n.simple().equals(type.simple())) continue;
            collision = true;
            break;
        }
        if (collision) {
            return type.qualified().replace('$', '.');
        }
        imports.add(type);
        return type.simple();
    }

    protected static abstract class Condition
    extends PropertyEditorCondition {
        protected Condition() {
        }

        protected final boolean evaluate(PropertyEditorPart part) {
            Reference referenceAnnotation;
            PropertyDef property = part.property().definition();
            if (property instanceof ValueProperty && property.isOfType(JavaTypeName.class) && (referenceAnnotation = (Reference)property.getAnnotation(Reference.class)) != null && referenceAnnotation.target() == JavaType.class) {
                return this.evaluate((JavaTypeConstraint)property.getAnnotation(JavaTypeConstraint.class));
            }
            return false;
        }

        protected abstract boolean evaluate(JavaTypeConstraint var1);
    }

    private static final class Resources
    extends NLS {
        public static String discourageDialogTitle;
        public static String discourageDefaultPackage;
        public static String discourageLowerCase;

        static {
            Resources.initializeMessages((String)JWSTypeCreateActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

