/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.actions;

import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.WebServicesException;
import oracle.eclipse.tools.webservices.compiler.CompilationException;
import oracle.eclipse.tools.webservices.compiler.WebServiceCompiler;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.wizards.common.DestinationDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateWsdlFromJwsAction
extends Action
implements IObjectActionDelegate {
    private static final String WSDL_EXTENSION = ".wsdl";
    private static final String SCHEMA_EXTENSION = ".xsd";
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        boolean enableAction = false;
        ICompilationUnit cu = this.getIcu();
        if (cu != null) {
            try {
                IType[] types = cu.getAllTypes();
                if (types != null && types.length > 0) {
                    enableAction = types[0].isClass();
                }
            }
            catch (JavaModelException jme) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)((Object)jme));
            }
        }
        action.setEnabled(enableAction);
    }

    public void run(IAction action) {
        IPath projPath;
        final ICompilationUnit cu = this.getIcu();
        final WSRuntime runtime = (WSRuntime)cu.getJavaProject().getProject().getAdapter(WSRuntime.class);
        if (runtime == null) {
            DialogService.showErrorDialog((String)Messages.generate_wsdl_from_jws_no_runtime);
            LoggingService.logWarning((Plugin)WebServicesUIPlugin.getDefault(), (String)("No runtime adapter found for: " + cu));
            return;
        }
        IResource resource = cu.getResource();
        assert (resource instanceof IFile);
        IFile srvcFile = (IFile)resource;
        IProject project = srvcFile.getProject();
        try {
            if (2 <= srvcFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)) {
                DialogService.showErrorDialog((String)Messages.generate_wsdl_from_jws_web_service_has_errors_msg);
                return;
            }
        }
        catch (CoreException coreException) {}
        try {
            String name = String.valueOf(runtime.getWSServiceName(cu)) + WSDL_EXTENSION;
            String schemaName = String.valueOf(runtime.getWSServiceName(cu)) + "_schema1" + SCHEMA_EXTENSION;
            Shell shell = WebServicesUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            DestinationDialog dialog = new DestinationDialog(shell, project, Messages.generate_wsdl_from_jws_select_dir_title, Messages.generate_wsdl_from_jws_select_dir_msg, 2, true, false);
            projPath = srvcFile.getProjectRelativePath().removeLastSegments(1);
            dialog.setOriginalFile((IResource)project.getFolder(projPath));
            if (dialog.open() != 0) {
                return;
            }
            IPath result = dialog.getResult();
            projPath = result.removeFirstSegments(1);
            IPath wsdlPath = projPath.append(name);
            IPath schemaPath = projPath.append(schemaName);
            IFile wsdlFile = project.getFile(wsdlPath);
            IFile schemaFile = project.getFile(schemaPath);
            if (wsdlFile.exists() || schemaFile.exists()) {
                if (!DialogService.showConfirmDialog((String)Messages.generate_wsdl_from_jws_wsdl_exists_title, (String)Messages.bind((String)Messages.generate_wsdl_from_jws_wsdl_exists_msg, (Object)wsdlPath.toOSString(), (Object)schemaPath.toOSString()))) {
                    return;
                }
                if (!ValidateEditUtil.validateEdit((IFile[])new IFile[]{wsdlFile, schemaFile}).isOK()) {
                    return;
                }
            }
        }
        catch (Exception x) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)x);
            DialogService.showErrorDialog((String)Messages.generate_wsdl_from_jws_web_service_create_errors_msg, (Throwable)x);
            return;
        }
        IFolder outputFolder = project.getFolder(projPath);
        try {
            Shell shell = WebServicesUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            ProgressMonitorDialog pd = new ProgressMonitorDialog(shell);
            pd.run(true, false, new IRunnableWithProgress((IContainer)outputFolder){
                private final /* synthetic */ IContainer val$outputFolder;
                {
                    this.val$outputFolder = iContainer;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.generate_wsdl_from_jws_status_title, 100);
                    try {
                        monitor.subTask(Messages.generate_wsdl_from_jws_status_setup_compiler);
                        WebServiceCompiler compiler = runtime.getWebServiceCompiler(cu);
                        if (compiler == null) {
                            return;
                        }
                        try {
                            monitor.worked(10);
                            monitor.subTask(Messages.generate_wsdl_from_jws_status_run_wsdlc);
                            compiler.setOutputFolder(this.val$outputFolder);
                            compiler.compile();
                            monitor.worked(90);
                        }
                        catch (CompilationException e) {
                            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                            DialogService.showErrorDialog((String)Messages.generate_wsdl_from_jws_web_service_has_errors_msg, (Throwable)e);
                        }
                        catch (WebServicesException e) {
                            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
                            String additionalErrorMessage = e.getLocalizedMessage();
                            Throwable t = e;
                            while (t != null && t.getCause() != null) {
                                t = t.getCause();
                            }
                            if (t != null && t != e) {
                                additionalErrorMessage = String.valueOf(additionalErrorMessage) + "\n\n" + t.getLocalizedMessage();
                            }
                            DialogService.showErrorDialog((String)(String.valueOf(Messages.generate_wsdl_from_jws_web_service_create_errors_msg) + "\n\n" + additionalErrorMessage), (Throwable)e);
                        }
                    }
                    finally {
                        runtime.close();
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            DialogService.showErrorDialog((String)Messages.generate_wsdl_from_jws_web_service_create_errors_msg, (Throwable)e);
        }
        catch (InterruptedException e) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)e);
            DialogService.showErrorDialog((String)Messages.generate_wsdl_from_jws_web_service_create_errors_msg, (Throwable)e);
        }
        try {
            outputFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)ce);
            DialogService.showErrorDialog((String)Messages.generate_wsdl_from_jws_web_service_create_errors_msg, (Throwable)ce);
        }
    }

    private ICompilationUnit getIcu() {
        IAdaptable a;
        IFile file;
        IJavaElement elem;
        Object obj;
        if (this.selection != null && this.selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)this.selection).getFirstElement()) instanceof IAdaptable && (elem = JavaCore.create((IFile)(file = (IFile)(a = (IAdaptable)obj).getAdapter(IFile.class)))) instanceof ICompilationUnit) {
            return (ICompilationUnit)elem;
        }
        return null;
    }
}

