/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui.actions;

import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.runtimes.WSRuntime;
import oracle.eclipse.tools.webservices.ui.Messages;
import oracle.eclipse.tools.webservices.ui.WebServicesUIPlugin;
import oracle.eclipse.tools.webservices.ui.actions.AbstractJavaAction;
import oracle.eclipse.tools.webservices.ui.wizards.jws.NewJWSFromExistingWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.PlatformUI;

public class GenerateJWSFromJavaAction
extends AbstractJavaAction {
    public void run(IAction action) {
        ICompilationUnit cu = this.getIcu();
        WSRuntime runtime = (WSRuntime)cu.getJavaProject().getProject().getAdapter(WSRuntime.class);
        if (runtime == null) {
            DialogService.showErrorDialog((String)Messages.generate_jws_from_java_no_runtime);
            LoggingService.logWarning((Plugin)WebServicesUIPlugin.getDefault(), (String)("No runtime adapter found for: " + cu));
            return;
        }
        IResource resource = cu.getResource();
        assert (resource instanceof IFile);
        IFile srvcFile = (IFile)resource;
        try {
            if (2 <= srvcFile.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2)) {
                DialogService.showErrorDialog((String)Messages.generate_jws_from_java_has_errors_msg);
                return;
            }
        }
        catch (CoreException coreException) {}
        try {
            NewJWSFromExistingWizard wizard = new NewJWSFromExistingWizard();
            wizard.init(PlatformUI.getWorkbench(), this.getSelection());
            this.openWizard((IWizard)wizard);
        }
        catch (Exception x) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)x);
            DialogService.showErrorDialog((String)Messages.generate_jws_from_java_create_errors_msg, (Throwable)x);
            return;
        }
        try {
            srvcFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (CoreException)ce);
            DialogService.showErrorDialog((String)Messages.generate_jws_from_java_create_errors_msg, (Throwable)ce);
        }
    }
}

