/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webservices.ui;

import java.io.IOException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webservices.ui.completion.context.WebServiceTemplateContextType;
import oracle.eclipse.tools.webservices.ui.refactor.template.RefactorTemplateContextType;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class WebServicesUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.webservices.ui";
    private static final String WEBSERVICE_TEMPLATES_KEY = "oracle.eclipse.tools.webservices.ui.webservicesTemplates";
    private ContextTypeRegistry contextTypeRegistry;
    private TemplateStore templateStore;
    private static WebServicesUIPlugin plugin;

    public WebServicesUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static WebServicesUIPlugin getDefault() {
        return plugin;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null) {
            this.templateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), WebServicesUIPlugin.getDefault().getPreferenceStore(), WEBSERVICE_TEMPLATES_KEY);
            try {
                this.templateStore.load();
            }
            catch (IOException ioe) {
                LoggingService.logException((Plugin)WebServicesUIPlugin.getDefault(), (Throwable)ioe);
            }
        }
        return this.templateStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.contextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType(WebServiceTemplateContextType.WebServiceContextTypeId.CLIENT_METHOD.getTypeId());
            TemplateContextType contextType = registry.getContextType(WebServiceTemplateContextType.WebServiceContextTypeId.CLIENT_METHOD.getTypeId());
            ((WebServiceTemplateContextType)contextType).initializeContextTypeResolvers();
            registry.addContextType("refactor-web-service");
            contextType = registry.getContextType("refactor-web-service");
            ((RefactorTemplateContextType)contextType).initializeContextTypeResolvers();
            this.contextTypeRegistry = registry;
        }
        return this.contextTypeRegistry;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        Images[] imagesArray = Images.values();
        int n = imagesArray.length;
        int n2 = 0;
        while (n2 < n) {
            Images img = imagesArray[n2];
            img.init(reg);
            ++n2;
        }
    }

    public static enum Images {
        NEW_WEB_METHOD("images/icons/new-web-method-16.png"),
        START("images/icons/start.png"),
        WEB_SERVICE("images/icons/web-service-16.png"),
        NEW_WS_WIZ("images/icons/wws-wiz.gif"),
        WEB_PROJ_WIZ("images/icons/ws-proj-wiz.gif"),
        WS_BANNER("images/icons/ws-banner.png"),
        WS_CLIENT_BANNER("images/icons/ws-client-banner.png"),
        WS_JAXB_BANNER("images/icons/jaxb-banner.png"),
        WS_WSDL("images/icons/wsdl.png"),
        WSDLC_WIZ("images/icons/web-service-wiz-16.png"),
        JAXWS_BINDINGS_BANNER("images/icons/bindings/jax-ws-bindings-banner.png"),
        JAXWS_BINDINGS_TOGGLE_DISPLAY("images/icons/bindings/toggle-display-icon.png"),
        JAXWS_BINDINGS_JAVA_DISPLAY("images/icons/bindings/java-display-name-icon.png"),
        JAXWS_BINDINGS_WSDL_DISPLAY("images/icons/bindings/wsdl-display-name-icon.png"),
        CHECKED("images/icons/checked.gif"),
        UNCHECKED("images/icons/unchecked.gif"),
        BROWSE("images/icons/browse.png");

        private String key;

        private Images(String path) {
            this.key = path;
        }

        private void init(ImageRegistry reg) {
            ImageDescriptor desc = WebServicesUIPlugin.imageDescriptorFromPlugin((String)WebServicesUIPlugin.PLUGIN_ID, (String)this.key);
            if (desc == null) {
                LoggingService.logError((Plugin)WebServicesUIPlugin.getDefault(), (String)("ERROR LOADING IMAGE " + this.key));
            } else {
                reg.put(this.key, desc);
            }
        }

        public Image getImage() {
            return WebServicesUIPlugin.getDefault().getImageRegistry().get(this.key);
        }

        public ImageDescriptor getImageDescriptor() {
            return WebServicesUIPlugin.getDefault().getImageRegistry().getDescriptor(this.key);
        }
    }
}

