/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.docs.epub.ui;

import java.io.File;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.docs.epub.ui.EPUB2Bean;
import org.eclipse.mylyn.internal.docs.epub.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MainPage
extends WizardPage {
    private DataBindingContext m_bindingContext;
    private Text titleText;
    private Text copyrightText;
    private Text coverText;
    private Text styleSheetText;
    private Text identifierText;
    private Text subjectText;
    private EPUB2Bean bean = new EPUB2Bean();
    private Combo schemeText;
    private Text authorText;
    private Combo combo;
    private DateTime dateTime;

    public MainPage() {
        super("wizardPage");
        this.setMessage(Messages.MainPage_0);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.docs.epub.ui", (String)"icons/wizard-banner.png"));
        this.setTitle(Messages.MainPage_1);
    }

    public MainPage(EPUB2Bean bean) {
        this();
        this.bean = bean;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, true));
        Group grpRequiredDetails = new Group(container, 0);
        grpRequiredDetails.setLayout((Layout)new GridLayout(4, false));
        GridData gd_grpRequiredDetails = new GridData(4, 128, true, false, 1, 1);
        gd_grpRequiredDetails.heightHint = 187;
        grpRequiredDetails.setLayoutData((Object)gd_grpRequiredDetails);
        grpRequiredDetails.setText(Messages.MainPage_2);
        Label lblTitle = new Label((Composite)grpRequiredDetails, 0);
        lblTitle.setText(Messages.MainPage_3);
        this.titleText = new Text((Composite)grpRequiredDetails, 2048);
        this.titleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label lblAuthor = new Label((Composite)grpRequiredDetails, 0);
        lblAuthor.setText(Messages.MainPage_4);
        this.authorText = new Text((Composite)grpRequiredDetails, 2048);
        this.authorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblNewLabel_1 = new Label((Composite)grpRequiredDetails, 0);
        lblNewLabel_1.setText(Messages.MainPage_5);
        this.dateTime = new DateTime((Composite)grpRequiredDetails, 0x10000800);
        Label lblIdentifier = new Label((Composite)grpRequiredDetails, 0);
        lblIdentifier.setText(Messages.MainPage_6);
        this.identifierText = new Text((Composite)grpRequiredDetails, 2048);
        this.identifierText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblScheme = new Label((Composite)grpRequiredDetails, 0);
        lblScheme.setText(Messages.MainPage_7);
        this.schemeText = new Combo((Composite)grpRequiredDetails, 2048);
        this.schemeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.schemeText.add(Messages.MainPage_8);
        Label lblCopyright = new Label((Composite)grpRequiredDetails, 0);
        lblCopyright.setText(Messages.MainPage_9);
        this.copyrightText = new Text((Composite)grpRequiredDetails, 2048);
        this.copyrightText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLanguage = new Label((Composite)grpRequiredDetails, 0);
        lblLanguage.setText(Messages.MainPage_10);
        this.combo = new Combo((Composite)grpRequiredDetails, 8);
        this.combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Set<String> locales = this.bean.getLocales().keySet();
        for (String name : locales) {
            this.combo.add(name);
        }
        Label lblDescription = new Label((Composite)grpRequiredDetails, 0);
        lblDescription.setText(Messages.MainPage_11);
        this.subjectText = new Text((Composite)grpRequiredDetails, 2048);
        this.subjectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Group grpCoverAndStyling = new Group(container, 0);
        grpCoverAndStyling.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        grpCoverAndStyling.setText(Messages.MainPage_12);
        grpCoverAndStyling.setLayout((Layout)new GridLayout(3, false));
        Label lblNewLabel = new Label((Composite)grpCoverAndStyling, 0);
        lblNewLabel.setText(Messages.MainPage_13);
        this.coverText = new Text((Composite)grpCoverAndStyling, 2048);
        this.coverText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Button button = new Button((Composite)grpCoverAndStyling, 0);
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterNames(new String[]{Messages.MainPage_15});
                dialog.setFilterExtensions(new String[]{"*.png;*.gif;*.jpg;*.svg"});
                dialog.setFilterPath(MainPage.this.bean.getMarkupFile().getAbsolutePath());
                String s = dialog.open();
                if (s != null) {
                    MainPage.this.coverText.setText(s);
                }
            }
        });
        Label lblStyleSheet = new Label((Composite)grpCoverAndStyling, 0);
        lblStyleSheet.setBounds(0, 0, 59, 14);
        lblStyleSheet.setText(Messages.MainPage_16);
        this.styleSheetText = new Text((Composite)grpCoverAndStyling, 2048);
        this.styleSheetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button button_1 = new Button((Composite)grpCoverAndStyling, 0);
        button_1.setText("...");
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterNames(new String[]{Messages.MainPage_18});
                dialog.setFilterExtensions(new String[]{"*.css"});
                dialog.setFilterPath(MainPage.this.bean.getMarkupFile().getAbsolutePath());
                String s = dialog.open();
                if (s != null) {
                    MainPage.this.styleSheetText.setText(s);
                }
            }
        });
        this.m_bindingContext = this.initDataBindings();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.m_bindingContext);
        this.setMessage(Messages.MainPage_0);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue textObserveTextObserveWidget = SWTObservables.observeText((Control)this.titleText, (int)24);
        IObservableValue beanTitleObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"title");
        UpdateValueStrategy titleStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        titleStrategy.setBeforeSetValidator((IValidator)new StringValidator("A title must be specified", (Control)this.titleText));
        bindingContext.bindValue((IObservableValue)textObserveTextObserveWidget, beanTitleObserveValue, titleStrategy, null);
        ISWTObservableValue text_3ObserveTextObserveWidget = SWTObservables.observeText((Control)this.authorText, (int)24);
        IObservableValue beanCreatorObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"creator");
        UpdateValueStrategy authorStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        authorStrategy.setBeforeSetValidator((IValidator)new StringValidator("An author must be specified", (Control)this.authorText));
        bindingContext.bindValue((IObservableValue)text_3ObserveTextObserveWidget, beanCreatorObserveValue, authorStrategy, null);
        ISWTObservableValue dateTimeObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.dateTime);
        IObservableValue beanPublicationDateObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"publicationDate");
        bindingContext.bindValue((IObservableValue)dateTimeObserveSelectionObserveWidget, beanPublicationDateObserveValue, null, null);
        ISWTObservableValue text_4ObserveTextObserveWidget = SWTObservables.observeText((Control)this.identifierText, (int)24);
        IObservableValue beanIdentifierObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"identifier");
        UpdateValueStrategy identifierStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        identifierStrategy.setBeforeSetValidator((IValidator)new StringValidator("An identifier must be specified", (Control)this.identifierText));
        bindingContext.bindValue((IObservableValue)text_4ObserveTextObserveWidget, beanIdentifierObserveValue, identifierStrategy, null);
        ISWTObservableValue schemeTextObserveTextObserveWidget = SWTObservables.observeText((Control)this.schemeText);
        IObservableValue beanIdSchemeObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"scheme");
        UpdateValueStrategy schemeStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        schemeStrategy.setBeforeSetValidator((IValidator)new StringValidator("An identifier scheme must be specified", (Control)this.schemeText));
        bindingContext.bindValue((IObservableValue)schemeTextObserveTextObserveWidget, beanIdSchemeObserveValue, schemeStrategy, null);
        ISWTObservableValue text_1ObserveTextObserveWidget = SWTObservables.observeText((Control)this.copyrightText, (int)24);
        IObservableValue beanRightsObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"rights");
        UpdateValueStrategy rightsStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        rightsStrategy.setBeforeSetValidator((IValidator)new StringValidator("Rights must be specified", (Control)this.copyrightText));
        bindingContext.bindValue((IObservableValue)text_1ObserveTextObserveWidget, beanRightsObserveValue, rightsStrategy, null);
        ISWTObservableValue comboObserveTextObserveWidget = SWTObservables.observeText((Control)this.combo);
        IObservableValue beanLanguageObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"language");
        UpdateValueStrategy languageStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        languageStrategy.setBeforeSetValidator((IValidator)new StringValidator("An language must be specified", (Control)this.combo));
        bindingContext.bindValue((IObservableValue)comboObserveTextObserveWidget, beanLanguageObserveValue, languageStrategy, null);
        ISWTObservableValue subjectTextObserveTextObserveWidget = SWTObservables.observeText((Control)this.subjectText, (int)24);
        IObservableValue beanSubjectObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"subject");
        UpdateValueStrategy subjectStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        subjectStrategy.setBeforeSetValidator((IValidator)new StringValidator("A subject must be specified", (Control)this.subjectText));
        bindingContext.bindValue((IObservableValue)subjectTextObserveTextObserveWidget, beanSubjectObserveValue, subjectStrategy, null);
        ISWTObservableValue coverObserveTextObserveWidget = SWTObservables.observeText((Control)this.coverText, (int)24);
        IObservableValue beanCoverObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"cover");
        UpdateValueStrategy coverStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        coverStrategy.setBeforeSetValidator((IValidator)new FileValidator("The cover image must be a valid image file of type PNG, SVG or JPEG.", (Control)this.coverText, new String[]{".png", ".svg", ".jpeg", ".jpg"}));
        bindingContext.bindValue((IObservableValue)coverObserveTextObserveWidget, beanCoverObserveValue, coverStrategy, null);
        ISWTObservableValue styleSheetTextObserveTextObserveWidget = SWTObservables.observeText((Control)this.styleSheetText, (int)24);
        IObservableValue beanStyleSheetObserveValue = PojoObservables.observeValue((Object)this.bean, (String)"styleSheet");
        UpdateValueStrategy styleSheetStrategy = new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE);
        styleSheetStrategy.setBeforeSetValidator((IValidator)new FileValidator("The style sheet must be a valid CSS file.", (Control)this.styleSheetText, new String[]{".css"}));
        bindingContext.bindValue((IObservableValue)styleSheetTextObserveTextObserveWidget, beanStyleSheetObserveValue, styleSheetStrategy, null);
        return bindingContext;
    }

    public boolean isPageComplete() {
        boolean ok = super.isPageComplete();
        if (ok) {
            this.setMessage("Press finish to generate an EPUB from the Wiki markup.");
        }
        return ok;
    }

    private final class FileValidator
    implements IValidator {
        private final String errorText;
        private final String[] fileSuffixes;
        private final ControlDecoration controlDecoration;

        public FileValidator(String errorText, Control control, String[] fileSuffixes) {
            this.errorText = errorText;
            this.fileSuffixes = fileSuffixes;
            this.controlDecoration = new ControlDecoration(control, 16512);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.controlDecoration.setImage(fieldDecoration.getImage());
            this.controlDecoration.hide();
        }

        public IStatus validate(Object value) {
            if (value instanceof String && ((String)value).length() > 0) {
                File file = new File((String)value);
                if (!file.exists()) {
                    this.controlDecoration.show();
                    return ValidationStatus.error((String)"The specified file must exist.");
                }
                boolean suffixOK = false;
                String name = file.getName();
                String[] stringArray = this.fileSuffixes;
                int n = this.fileSuffixes.length;
                int n2 = 0;
                while (n2 < n) {
                    String suffix = stringArray[n2];
                    if (name.endsWith(suffix)) {
                        suffixOK = true;
                    }
                    ++n2;
                }
                if (!suffixOK) {
                    this.controlDecoration.show();
                    return ValidationStatus.error((String)this.errorText);
                }
            }
            this.controlDecoration.hide();
            return ValidationStatus.ok();
        }
    }

    private final class StringValidator
    implements IValidator {
        private final String errorText;
        private final ControlDecoration controlDecoration;

        public StringValidator(String errorText, Control control) {
            this.errorText = errorText;
            this.controlDecoration = new ControlDecoration(control, 16512);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED");
            this.controlDecoration.setImage(fieldDecoration.getImage());
        }

        public IStatus validate(Object value) {
            String text;
            if (value instanceof String && (text = (String)value).trim().length() == 0) {
                this.controlDecoration.show();
                return ValidationStatus.cancel((String)this.errorText);
            }
            this.controlDecoration.hide();
            return ValidationStatus.ok();
        }
    }
}

