/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.TypeDeclarationTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmTypeMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlSchema;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.ELXmlAccessOrder;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.ELXmlAccessType;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmJavaTypeImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmXmlEnumImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.oxm.OxmXmlSchemaImpl;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.OxmFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.validation.JptJaxbEclipseLinkCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OxmXmlBindingsImpl
extends AbstractJaxbContextNode
implements OxmXmlBindings {
    protected EXmlBindings eXmlBindings;
    protected XmlAccessType accessType;
    protected XmlAccessType specifiedAccessType;
    protected XmlAccessOrder specifiedAccessOrder;
    protected boolean xmlMappingMetadataComplete;
    protected String specifiedPackageName;
    protected String impliedPackageName;
    protected final OxmXmlSchema xmlSchema;
    protected final AbstractJaxbNode.ContextListContainer<OxmXmlEnum, EXmlEnum> xmlEnumContainer;
    protected final AbstractJaxbNode.ContextListContainer<OxmJavaType, EJavaType> javaTypeContainer;

    public OxmXmlBindingsImpl(OxmFile parent, EXmlBindings eXmlBindings) {
        super((JaxbNode)parent);
        this.eXmlBindings = eXmlBindings;
        this.initAccessType();
        this.specifiedAccessOrder = this.buildSpecifiedAccessOrder();
        this.xmlMappingMetadataComplete = this.buildXmlMappingMetadataComplete();
        this.specifiedPackageName = this.buildSpecifiedPackageName();
        this.xmlSchema = this.buildXmlSchema();
        this.xmlEnumContainer = this.buildXmlEnumContainer();
        this.javaTypeContainer = this.buildJavaTypeContainer();
    }

    @Override
    public EXmlBindings getEXmlBindings() {
        return this.eXmlBindings;
    }

    @Override
    public OxmFile getOxmFile() {
        return (OxmFile)super.getParent();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncAccessType();
        this.setSpecifiedAccessOrder_(this.buildSpecifiedAccessOrder());
        this.setXmlMappingMetadataComplete_(this.buildXmlMappingMetadataComplete());
        this.setSpecifiedPackageName_(this.buildSpecifiedPackageName());
        this.xmlSchema.synchronizeWithResourceModel();
        this.xmlEnumContainer.synchronizeWithResourceModel();
        this.javaTypeContainer.synchronizeWithResourceModel();
    }

    public void update() {
        super.update();
        this.setImpliedPackageName_(this.buildImpliedPackageName());
        this.xmlSchema.update();
        this.xmlEnumContainer.update();
        this.javaTypeContainer.update();
    }

    public XmlAccessType getAccessType() {
        return this.accessType;
    }

    protected void setAccessType_(XmlAccessType accessType) {
        XmlAccessType old = this.accessType;
        this.accessType = accessType;
        this.firePropertyChanged("accessType", old, accessType);
    }

    public XmlAccessType getDefaultAccessType() {
        return XmlAccessType.PUBLIC_MEMBER;
    }

    public XmlAccessType getSpecifiedAccessType() {
        return this.specifiedAccessType;
    }

    public void setSpecifiedAccessType(XmlAccessType newAccessType) {
        this.setSpecifiedAccessType_(newAccessType);
        this.eXmlBindings.setXmlAccessorType(ELXmlAccessType.toOxmResourceModel(newAccessType));
    }

    protected void setSpecifiedAccessType_(XmlAccessType newAccessType) {
        XmlAccessType oldAccessType = this.specifiedAccessType;
        this.specifiedAccessType = newAccessType;
        this.firePropertyChanged("specifiedAccessType", oldAccessType, newAccessType);
    }

    protected XmlAccessType getResourceAccessType() {
        return ELXmlAccessType.fromOxmResourceModel(this.eXmlBindings.getXmlAccessorType());
    }

    protected void initAccessType() {
        XmlAccessType specified = this.getResourceAccessType();
        XmlAccessType actual = specified != null ? specified : this.getDefaultAccessType();
        this.specifiedAccessType = specified;
        this.accessType = actual;
    }

    protected void syncAccessType() {
        XmlAccessType specified = this.getResourceAccessType();
        XmlAccessType actual = specified != null ? specified : this.getDefaultAccessType();
        this.setSpecifiedAccessType_(specified);
        this.setAccessType_(actual);
    }

    public XmlAccessOrder getAccessOrder() {
        return this.specifiedAccessOrder != null ? this.specifiedAccessOrder : this.getDefaultAccessOrder();
    }

    public XmlAccessOrder getDefaultAccessOrder() {
        return XmlAccessOrder.UNDEFINED;
    }

    public XmlAccessOrder getSpecifiedAccessOrder() {
        return this.specifiedAccessOrder;
    }

    public void setSpecifiedAccessOrder(XmlAccessOrder newAccessOrder) {
        this.eXmlBindings.setXmlAccessorOrder(ELXmlAccessOrder.toOxmResourceModel(newAccessOrder));
        this.setSpecifiedAccessOrder_(newAccessOrder);
    }

    protected void setSpecifiedAccessOrder_(XmlAccessOrder newAccessOrder) {
        XmlAccessOrder oldAccessOrder = this.specifiedAccessOrder;
        this.specifiedAccessOrder = newAccessOrder;
        this.firePropertyChanged("specifiedAccessOrder", oldAccessOrder, newAccessOrder);
    }

    protected XmlAccessOrder buildSpecifiedAccessOrder() {
        return ELXmlAccessOrder.fromOxmResourceModel(this.eXmlBindings.getXmlAccessorOrder());
    }

    @Override
    public boolean isXmlMappingMetadataComplete() {
        return this.xmlMappingMetadataComplete;
    }

    @Override
    public void setXmlMappingMetadataComplete(boolean newValue) {
        this.eXmlBindings.setXmlMappingMetadataComplete(newValue ? Boolean.valueOf(newValue) : null);
        this.setXmlMappingMetadataComplete_(newValue);
    }

    protected void setXmlMappingMetadataComplete_(boolean newValue) {
        boolean oldValue = this.xmlMappingMetadataComplete;
        this.xmlMappingMetadataComplete = newValue;
        this.firePropertyChanged("xmlMappingMetadataComplete", oldValue, newValue);
    }

    protected boolean buildXmlMappingMetadataComplete() {
        Boolean eValue = this.eXmlBindings.getXmlMappingMetadataComplete();
        return eValue == null ? false : eValue;
    }

    @Override
    public String getSpecifiedPackageName() {
        return this.specifiedPackageName;
    }

    @Override
    public void setSpecifiedPackageName(String packageName) {
        this.eXmlBindings.setPackageName(packageName);
        this.setSpecifiedPackageName_(packageName);
    }

    protected void setSpecifiedPackageName_(String packageName) {
        String oldPackageName = this.specifiedPackageName;
        this.specifiedPackageName = packageName;
        this.firePropertyChanged("specifiedPackageName", oldPackageName, packageName);
    }

    protected String buildSpecifiedPackageName() {
        return this.eXmlBindings.getPackageName();
    }

    @Override
    public String getImpliedPackageName() {
        return this.impliedPackageName;
    }

    protected void setImpliedPackageName_(String packageName) {
        String oldPackageName = this.impliedPackageName;
        this.impliedPackageName = packageName;
        this.firePropertyChanged("impliedPackageName", oldPackageName, packageName);
    }

    protected String buildImpliedPackageName() {
        for (OxmJavaType javaType : this.getJavaTypes()) {
            String packageName;
            String specifiedName = javaType.getSpecifiedName();
            String string = packageName = StringTools.isBlank((String)specifiedName) ? null : TypeDeclarationTools.packageName((String)specifiedName);
            if (StringTools.isBlank((String)packageName)) continue;
            return packageName;
        }
        return "";
    }

    @Override
    public String getPackageName() {
        return this.specifiedPackageName != null ? this.specifiedPackageName : this.impliedPackageName;
    }

    @Override
    public String getQualifiedName(String className) {
        if (StringTools.isBlank((String)className)) {
            return "";
        }
        if (className.indexOf(46) >= 0) {
            return className;
        }
        String componentClassName = TypeDeclarationTools.elementTypeName((String)className);
        if (ClassNameTools.isPrimitive((String)componentClassName)) {
            return className;
        }
        if (TypeDeclarationTools.isJavaLangClass((String)className)) {
            return StringTools.concatenate((String[])new String[]{"java.lang.", className});
        }
        if (StringTools.isBlank((String)this.specifiedPackageName)) {
            return className;
        }
        return StringTools.concatenate((String[])new String[]{this.specifiedPackageName, ".", className});
    }

    @Override
    public OxmXmlSchema getXmlSchema() {
        return this.xmlSchema;
    }

    protected OxmXmlSchema buildXmlSchema() {
        return new OxmXmlSchemaImpl(this);
    }

    @Override
    public ListIterable<OxmXmlEnum> getXmlEnums() {
        return this.xmlEnumContainer.getContextElements();
    }

    @Override
    public int getXmlEnumsSize() {
        return this.xmlEnumContainer.getContextElementsSize();
    }

    @Override
    public OxmXmlEnum getXmlEnum(int index) {
        return (OxmXmlEnum)this.xmlEnumContainer.getContextElement(index);
    }

    @Override
    public OxmXmlEnum getXmlEnum(String qualifiedName) {
        for (OxmXmlEnum xmlEnum : this.getXmlEnums()) {
            if (!ObjectTools.equals((Object)xmlEnum.getTypeName().getFullyQualifiedName(), (Object)qualifiedName)) continue;
            return xmlEnum;
        }
        return null;
    }

    @Override
    public OxmXmlEnum addXmlEnum(int index) {
        EXmlEnum eXmlEnum = OxmFactory.eINSTANCE.createEXmlEnum();
        OxmXmlEnum xmlEnum = (OxmXmlEnum)this.xmlEnumContainer.addContextElement(index, (Object)eXmlEnum);
        this.eXmlBindings.getXmlEnums().add(index, (Object)eXmlEnum);
        return xmlEnum;
    }

    @Override
    public void removeXmlEnum(int index) {
        this.removeXmlEnum_(index);
        this.eXmlBindings.getXmlEnums().remove(index);
    }

    protected void removeXmlEnum_(int index) {
        this.xmlEnumContainer.removeContextElement(index);
    }

    protected ListIterable<EXmlEnum> getEXmlEnums() {
        return IterableTools.cloneLive(this.eXmlBindings.getXmlEnums());
    }

    protected OxmXmlEnum buildXmlEnum(EXmlEnum eXmlEnum) {
        return new OxmXmlEnumImpl((OxmXmlBindings)this, eXmlEnum);
    }

    protected AbstractJaxbNode.ContextListContainer<OxmXmlEnum, EXmlEnum> buildXmlEnumContainer() {
        XmlEnumContainer container = new XmlEnumContainer();
        container.initialize();
        return container;
    }

    @Override
    public ListIterable<OxmJavaType> getJavaTypes() {
        return this.javaTypeContainer.getContextElements();
    }

    @Override
    public int getJavaTypesSize() {
        return this.javaTypeContainer.getContextElementsSize();
    }

    @Override
    public OxmJavaType getJavaType(int index) {
        return (OxmJavaType)this.javaTypeContainer.getContextElement(index);
    }

    @Override
    public OxmJavaType getJavaType(String qualifiedName) {
        for (OxmJavaType javaType : this.getJavaTypes()) {
            if (!ObjectTools.equals((Object)javaType.getTypeName().getFullyQualifiedName(), (Object)qualifiedName)) continue;
            return javaType;
        }
        return null;
    }

    @Override
    public OxmJavaType addJavaType(int index) {
        EJavaType eJavaType = OxmFactory.eINSTANCE.createEJavaType();
        OxmJavaType javaType = (OxmJavaType)this.javaTypeContainer.addContextElement(index, (Object)eJavaType);
        this.eXmlBindings.getJavaTypes().add(index, (Object)eJavaType);
        return javaType;
    }

    @Override
    public void removeJavaType(int index) {
        this.removeJavaType_(index);
        this.eXmlBindings.getJavaTypes().remove(index);
    }

    protected void removeJavaType_(int index) {
        this.javaTypeContainer.removeContextElement(index);
    }

    protected ListIterable<EJavaType> getEJavaTypes() {
        return IterableTools.cloneLive(this.eXmlBindings.getJavaTypes());
    }

    protected OxmJavaType buildJavaType(EJavaType eJavaType) {
        return new OxmJavaTypeImpl((OxmXmlBindings)this, eJavaType);
    }

    protected AbstractJaxbNode.ContextListContainer<OxmJavaType, EJavaType> buildJavaTypeContainer() {
        JavaTypeContainer container = new JavaTypeContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<OxmTypeMapping> getTypeMappings() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.getXmlEnums(), this.getJavaTypes()});
    }

    @Override
    public OxmTypeMapping getTypeMapping(String typeName) {
        OxmXmlEnum mapping = this.getXmlEnum(typeName);
        if (mapping != null) {
            return mapping;
        }
        return this.getJavaType(typeName);
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.eXmlBindings.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateVersion(messages);
        for (OxmXmlEnum xmlEnum : this.getXmlEnums()) {
            xmlEnum.validate(messages, reporter);
        }
        for (OxmJavaType javaType : this.getJavaTypes()) {
            javaType.validate(messages, reporter);
        }
    }

    protected void validateVersion(List<IMessage> messages) {
        if (ObjectTools.notEquals((Object)this.getLatestDocumentVersion(), (Object)this.eXmlBindings.getDocumentVersion())) {
            messages.add(ValidationMessageTools.buildValidationMessage((IResource)this.getResource(), (TextRange)this.eXmlBindings.getVersionTextRange(), (ValidationMessage)JptJaxbEclipseLinkCoreValidationMessages.OXM_FILE__NOT_LATEST_VERSION));
        }
    }

    protected String getLatestDocumentVersion() {
        return this.getJaxbProject().getPlatform().getDefinition().getMostRecentSupportedResourceType(this.getContentType()).getVersion();
    }

    protected IContentType getContentType() {
        return EXmlBindings.CONTENT_TYPE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaTypeContainer
    extends AbstractJaxbNode.ContextListContainer<OxmJavaType, EJavaType> {
        protected JavaTypeContainer() {
            super((AbstractJaxbNode)OxmXmlBindingsImpl.this);
        }

        protected String getContextElementsPropertyName() {
            return "javaTypes";
        }

        protected OxmJavaType buildContextElement(EJavaType resourceElement) {
            return OxmXmlBindingsImpl.this.buildJavaType(resourceElement);
        }

        protected ListIterable<EJavaType> getResourceElements() {
            return OxmXmlBindingsImpl.this.getEJavaTypes();
        }

        protected EJavaType getResourceElement(OxmJavaType contextElement) {
            return contextElement.getETypeMapping();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlEnumContainer
    extends AbstractJaxbNode.ContextListContainer<OxmXmlEnum, EXmlEnum> {
        protected XmlEnumContainer() {
            super((AbstractJaxbNode)OxmXmlBindingsImpl.this);
        }

        protected String getContextElementsPropertyName() {
            return "xmlEnums";
        }

        protected OxmXmlEnum buildContextElement(EXmlEnum resourceElement) {
            return OxmXmlBindingsImpl.this.buildXmlEnum(resourceElement);
        }

        protected ListIterable<EXmlEnum> getResourceElements() {
            return OxmXmlBindingsImpl.this.getEXmlEnums();
        }

        protected EXmlEnum getResourceElement(OxmXmlEnum contextElement) {
            return contextElement.getETypeMapping();
        }
    }
}

