/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.GitLabelProvider;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ShowInContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitEditorPage
extends FormPage
implements ISchedulingRule {
    private static final String SIGNED_OFF_BY = "Signed-off-by: {0} <{1}>";
    public static final int PARENT_LENGTH = 20;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
    private Composite tagLabelArea;
    private Section branchSection;
    private TableViewer branchViewer;
    private Section diffSection;
    private CommitFileDiffViewer diffViewer;

    public CommitEditorPage(FormEditor editor) {
        this(editor, "commitPage", UIText.CommitEditorPage_Title);
    }

    public CommitEditorPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    private void hookExpansionGrabbing(final Section section) {
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ((GridData)section.getLayoutData()).grabExcessVerticalSpace = e.getState();
                CommitEditorPage.this.getManagedForm().getForm().getBody().layout(true, true);
            }
        });
    }

    private Image getImage(ImageDescriptor descriptor) {
        return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
    }

    private Section createSection(Composite parent, FormToolkit toolkit, int span) {
        Section section = toolkit.createSection(parent, 322);
        GridDataFactory.fillDefaults().span(span, 1).grab(true, true).applyTo((Control)section);
        return section;
    }

    private Composite createSectionClient(Section parent, FormToolkit toolkit) {
        Composite client = toolkit.createComposite((Composite)parent);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(client);
        return client;
    }

    private boolean isSignedOffBy(PersonIdent person) {
        RevCommit commit = this.getCommit().getRevCommit();
        return commit.getFullMessage().indexOf(this.getSignedOffByLine(person)) != -1;
    }

    private String getSignedOffByLine(PersonIdent person) {
        return MessageFormat.format(SIGNED_OFF_BY, person.getName(), person.getEmailAddress());
    }

    private String replaceSignedOffByLine(String message, PersonIdent person) {
        Pattern pattern = Pattern.compile("^\\s*" + Pattern.quote(this.getSignedOffByLine(person)) + "\\s*$", 8);
        return pattern.matcher(message).replaceAll("");
    }

    private Composite createUserArea(Composite parent, FormToolkit toolkit, PersonIdent person, boolean author) {
        Composite userArea = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(2, 2).numColumns(3).applyTo(userArea);
        Label userLabel = toolkit.createLabel(userArea, null);
        userLabel.setImage(this.getImage(author ? UIIcons.ELCL16_AUTHOR : UIIcons.ELCL16_COMMITTER));
        if (author) {
            userLabel.setToolTipText(UIText.CommitEditorPage_TooltipAuthor);
        } else {
            userLabel.setToolTipText(UIText.CommitEditorPage_TooltipCommitter);
        }
        boolean signedOff = this.isSignedOffBy(person);
        Text userText = new Text(userArea, 0x800008);
        userText.setText(MessageFormat.format(author ? UIText.CommitEditorPage_LabelAuthor : UIText.CommitEditorPage_LabelCommitter, person.getName(), person.getEmailAddress(), person.getWhen()));
        toolkit.adapt((Control)userText, false, false);
        userText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        GridDataFactory.fillDefaults().span(signedOff ? 1 : 2, 1).applyTo((Control)userText);
        if (signedOff) {
            Label signedOffLabel = toolkit.createLabel(userArea, null);
            signedOffLabel.setImage(this.getImage(UIIcons.SIGNED_OFF));
            if (author) {
                signedOffLabel.setToolTipText(UIText.CommitEditorPage_TooltipSignedOffByAuthor);
            } else {
                signedOffLabel.setToolTipText(UIText.CommitEditorPage_TooltipSignedOffByCommitter);
            }
        }
        return userArea;
    }

    private void updateSectionClient(Section section, Composite client, FormToolkit toolkit) {
        this.hookExpansionGrabbing(section);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    private void createHeaderArea(Composite parent, FormToolkit toolkit, int span) {
        int count;
        PersonIdent committer;
        RevCommit commit = this.getCommit().getRevCommit();
        Composite top = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).span(span, 1).applyTo((Control)top);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(top);
        Composite userArea = toolkit.createComposite(top);
        GridLayoutFactory.fillDefaults().spacing(2, 2).numColumns(1).applyTo(userArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)userArea);
        PersonIdent author = commit.getAuthorIdent();
        if (author != null) {
            this.createUserArea(userArea, toolkit, author, true);
        }
        if ((committer = commit.getCommitterIdent()) != null && !committer.equals((Object)author)) {
            this.createUserArea(userArea, toolkit, committer, false);
        }
        if ((count = commit.getParentCount()) > 0) {
            Composite parents = toolkit.createComposite(top);
            GridLayoutFactory.fillDefaults().spacing(2, 2).numColumns(2).applyTo(parents);
            GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)parents);
            int i = 0;
            while (i < count) {
                final RevCommit parentCommit = commit.getParent(i);
                toolkit.createLabel(parents, UIText.CommitEditorPage_LabelParent).setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
                Hyperlink link = toolkit.createHyperlink(parents, parentCommit.abbreviate(20).name(), 0);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            CommitEditor.open(new RepositoryCommit(CommitEditorPage.this.getCommit().getRepository(), parentCommit));
                            if ((e.getStateMask() & SWT.MOD1) != 0) {
                                CommitEditorPage.this.getEditor().close(false);
                            }
                        }
                        catch (PartInitException e1) {
                            Activator.logError("Error opening commit editor", e1);
                        }
                    }
                });
                ++i;
            }
        }
        this.createTagsArea(userArea, toolkit, 2);
    }

    private List<Ref> getTags() {
        Repository repository = this.getCommit().getRepository();
        ArrayList<Ref> tags = new ArrayList<Ref>(repository.getTags().values());
        Collections.sort(tags, new Comparator<Ref>(){

            @Override
            public int compare(Ref r1, Ref r2) {
                return Repository.shortenRefName((String)r1.getName()).compareToIgnoreCase(Repository.shortenRefName((String)r2.getName()));
            }
        });
        return tags;
    }

    private void createTagsArea(Composite parent, FormToolkit toolkit, int span) {
        Composite tagArea = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(tagArea);
        GridDataFactory.fillDefaults().span(span, 1).grab(true, false).applyTo((Control)tagArea);
        toolkit.createLabel(tagArea, UIText.CommitEditorPage_LabelTags).setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.tagLabelArea = toolkit.createComposite(tagArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tagLabelArea);
        GridLayoutFactory.fillDefaults().spacing(1, 1).applyTo(this.tagLabelArea);
    }

    private void fillDiffs(FileDiff[] diffs) {
        this.diffViewer.setInput(diffs);
        this.diffSection.setText(MessageFormat.format(UIText.CommitEditorPage_SectionFiles, diffs.length));
    }

    private void fillTags(FormToolkit toolkit, List<Ref> tags) {
        Control[] controlArray = this.tagLabelArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(tags.size()).applyTo(this.tagLabelArea);
        for (Ref tag : tags) {
            boolean annotated;
            ObjectId id = tag.getPeeledObjectId();
            boolean bl = annotated = id != null;
            if (id == null) {
                id = tag.getObjectId();
            }
            CLabel tagLabel = new CLabel(this.tagLabelArea, 0);
            toolkit.adapt((Control)tagLabel, false, false);
            if (annotated) {
                tagLabel.setImage(this.getImage(UIIcons.TAG_ANNOTATED));
            } else {
                tagLabel.setImage(this.getImage(UIIcons.TAG));
            }
            tagLabel.setText(Repository.shortenRefName((String)tag.getName()));
        }
    }

    private void createMessageArea(Composite parent, FormToolkit toolkit, int span) {
        PersonIdent committer;
        Section messageSection = this.createSection(parent, toolkit, span);
        Composite messageArea = this.createSectionClient(messageSection, toolkit);
        messageSection.setText(UIText.CommitEditorPage_SectionMessage);
        RevCommit commit = this.getCommit().getRevCommit();
        String message = commit.getFullMessage();
        PersonIdent author = commit.getAuthorIdent();
        if (author != null) {
            message = this.replaceSignedOffByLine(message, author);
        }
        if ((committer = commit.getCommitterIdent()) != null) {
            message = this.replaceSignedOffByLine(message, committer);
        }
        SpellcheckableMessageArea textContent = new SpellcheckableMessageArea(messageArea, message, true, toolkit.getBorderStyle()){

            protected IAdaptable getDefaultTarget() {
                return new PlatformObject(){

                    public Object getAdapter(Class adapter) {
                        return Platform.getAdapterManager().getAdapter((Object)CommitEditorPage.this.getEditorInput(), adapter);
                    }
                };
            }

            protected void createMarginPainter() {
            }
        };
        if ((toolkit.getBorderStyle() & 0x800) == 0) {
            textContent.setData("FormWidgetFactory.drawBorder", "textBorder");
        }
        GridDataFactory.fillDefaults().hint(-1, 80).grab(true, true).applyTo((Control)textContent);
        this.updateSectionClient(messageSection, messageArea, toolkit);
    }

    private void createBranchesArea(Composite parent, FormToolkit toolkit, int span) {
        this.branchSection = this.createSection(parent, toolkit, span);
        this.branchSection.setText(UIText.CommitEditorPage_SectionBranchesEmpty);
        Composite branchesArea = this.createSectionClient(this.branchSection, toolkit);
        this.branchViewer = new TableViewer(toolkit.createTable(branchesArea, 768));
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 50).applyTo(this.branchViewer.getControl());
        this.branchViewer.setSorter(new ViewerSorter());
        this.branchViewer.setLabelProvider((IBaseLabelProvider)new GitLabelProvider(){

            public String getText(Object element) {
                return Repository.shortenRefName((String)super.getText(element));
            }
        });
        this.branchViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.branchViewer.getTable().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.updateSectionClient(this.branchSection, branchesArea, toolkit);
    }

    private void fillBranches(List<Ref> result) {
        this.branchViewer.setInput(result);
        this.branchSection.setText(MessageFormat.format(UIText.CommitEditorPage_SectionBranches, result.size()));
    }

    private void createFilesArea(Composite parent, FormToolkit toolkit, int span) {
        this.diffSection = this.createSection(parent, toolkit, span);
        this.diffSection.setText(UIText.CommitEditorPage_SectionFilesEmpty);
        Composite filesArea = this.createSectionClient(this.diffSection, toolkit);
        this.diffViewer = new CommitFileDiffViewer(filesArea, (IWorkbenchSite)this.getSite(), 0x10302 | toolkit.getBorderStyle());
        this.diffViewer.getTable().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 80).applyTo(this.diffViewer.getControl());
        this.diffViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.diffViewer.setTreeWalk(this.getCommit().getRepository(), null);
        this.updateSectionClient(this.diffSection, filesArea, toolkit);
    }

    private RepositoryCommit getCommit() {
        return (RepositoryCommit)((Object)this.getEditor().getAdapter(RepositoryCommit.class));
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite body = managedForm.getForm().getBody();
        body.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitEditorPage.this.resources.dispose();
            }
        });
        FillLayout bodyLayout = new FillLayout();
        bodyLayout.marginHeight = 5;
        bodyLayout.marginWidth = 5;
        body.setLayout((Layout)bodyLayout);
        FormToolkit toolkit = managedForm.getToolkit();
        Composite displayArea = toolkit.createComposite(body);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(displayArea);
        this.createHeaderArea(displayArea, toolkit, 2);
        this.createMessageArea(displayArea, toolkit, 2);
        this.createFilesArea(displayArea, toolkit, 1);
        this.createBranchesArea(displayArea, toolkit, 1);
        this.loadSections();
    }

    private List<Ref> loadTags() {
        RepositoryCommit repoCommit = this.getCommit();
        RevCommit commit = repoCommit.getRevCommit();
        Repository repository = repoCommit.getRepository();
        ArrayList<Ref> tags = new ArrayList<Ref>();
        for (Ref tag : this.getTags()) {
            ObjectId id = (tag = repository.peel(tag)).getPeeledObjectId();
            if (id == null) {
                id = tag.getObjectId();
            }
            if (!commit.equals((AnyObjectId)id)) continue;
            tags.add(tag);
        }
        return tags;
    }

    private List<Ref> loadBranches() {
        Repository repository = this.getCommit().getRepository();
        RevCommit commit = this.getCommit().getRevCommit();
        RevWalk revWalk = new RevWalk(repository);
        try {
            HashMap refsMap = new HashMap();
            refsMap.putAll(repository.getRefDatabase().getRefs("refs/heads/"));
            refsMap.putAll(repository.getRefDatabase().getRefs("refs/remotes/"));
            return RevWalkUtils.findBranchesReachableFrom((RevCommit)commit, (RevWalk)revWalk, refsMap.values());
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, false);
            return Collections.emptyList();
        }
    }

    private void loadSections() {
        RepositoryCommit commit = this.getCommit();
        Job refreshJob = new Job(MessageFormat.format(UIText.CommitEditorPage_JobName, commit.getRevCommit().name())){

            protected IStatus run(IProgressMonitor monitor) {
                final List tags = CommitEditorPage.this.loadTags();
                final List branches = CommitEditorPage.this.loadBranches();
                final FileDiff[] diffs = CommitEditorPage.this.getCommit().getDiffs();
                final ScrolledForm form = CommitEditorPage.this.getManagedForm().getForm();
                if (UIUtils.isUsable((Control)form)) {
                    form.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (!UIUtils.isUsable((Control)form)) {
                                return;
                            }
                            CommitEditorPage.this.fillTags(CommitEditorPage.this.getManagedForm().getToolkit(), tags);
                            CommitEditorPage.this.fillDiffs(diffs);
                            CommitEditorPage.this.fillBranches(branches);
                            form.layout(true, true);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        refreshJob.setRule((ISchedulingRule)this);
        refreshJob.schedule();
    }

    public void refresh() {
        this.loadSections();
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    ShowInContext getShowInContext() {
        if (this.diffViewer != null && this.diffViewer.getControl().isFocusControl()) {
            return this.diffViewer.getShowInContext();
        }
        return null;
    }
}

