/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class LambdaExpressionsFix
extends CompilationUnitRewriteOperationsFix {
    public static LambdaExpressionsFix createConvertToLambdaFix(ClassInstanceCreation cic) {
        CompilationUnit root = (CompilationUnit)cic.getRoot();
        if (!JavaModelUtil.is18OrHigher(root.getJavaElement().getJavaProject())) {
            return null;
        }
        if (!LambdaExpressionsFix.isFunctionalAnonymous(cic)) {
            return null;
        }
        CreateLambdaOperation op = new CreateLambdaOperation(Collections.singletonList(cic));
        return new LambdaExpressionsFix(FixMessages.LambdaExpressionsFix_convert_to_lambda_expression, root, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
    }

    public static IProposableFix createConvertToAnonymousClassCreationsFix(LambdaExpression lambda) {
        if (lambda.resolveTypeBinding() == null || lambda.resolveTypeBinding().getFunctionalInterfaceMethod() == null) {
            return null;
        }
        CreateAnonymousClassCreationOperation op = new CreateAnonymousClassCreationOperation(Collections.singletonList(lambda));
        CompilationUnit root = (CompilationUnit)lambda.getRoot();
        return new LambdaExpressionsFix(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, root, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean useLambda, boolean useAnonymous) {
        if (!JavaModelUtil.is18OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        if (useLambda) {
            ArrayList<ClassInstanceCreation> convertibleNodes = FunctionalAnonymousClassesFinder.perform((ASTNode)compilationUnit);
            if (convertibleNodes.isEmpty()) {
                return null;
            }
            CreateLambdaOperation op = new CreateLambdaOperation(convertibleNodes);
            return new LambdaExpressionsFix(FixMessages.LambdaExpressionsFix_convert_to_lambda_expression, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
        }
        if (useAnonymous) {
            ArrayList<LambdaExpression> convertibleNodes = LambdaExpressionsFinder.perform((ASTNode)compilationUnit);
            if (convertibleNodes.isEmpty()) {
                return null;
            }
            CreateAnonymousClassCreationOperation op = new CreateAnonymousClassCreationOperation(convertibleNodes);
            return new LambdaExpressionsFix(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, compilationUnit, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{op});
        }
        return null;
    }

    protected LambdaExpressionsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    static boolean isFunctionalAnonymous(ClassInstanceCreation node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding[] interfaces = typeBinding.getInterfaces();
        if (interfaces.length != 1) {
            return false;
        }
        if (interfaces[0].getFunctionalInterfaceMethod() == null) {
            return false;
        }
        AnonymousClassDeclaration anonymTypeDecl = node.getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return false;
        }
        List bodyDeclarations = anonymTypeDecl.bodyDeclarations();
        if (bodyDeclarations.size() != 1) {
            return false;
        }
        BodyDeclaration bodyDeclaration = (BodyDeclaration)bodyDeclarations.get(0);
        if (!(bodyDeclaration instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)bodyDeclaration;
        IMethodBinding methodBinding = methodDecl.resolveBinding();
        if (methodBinding == null) {
            return false;
        }
        if (methodBinding.isGenericMethod()) {
            return false;
        }
        if (SuperThisReferenceFinder.hasReference(methodDecl)) {
            return false;
        }
        return LambdaExpressionsFix.isInTargetTypeContext(node);
    }

    private static boolean isInTargetTypeContext(ClassInstanceCreation node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent == ReturnStatement.EXPRESSION_PROPERTY) {
            MethodDeclaration methodDeclaration = ASTResolving.findParentMethodDeclaration((ASTNode)node);
            if (methodDeclaration == null) {
                return false;
            }
            IMethodBinding methodBinding = methodDeclaration.resolveBinding();
            if (methodBinding == null) {
                return false;
            }
            return methodBinding.getReturnType().getFunctionalInterfaceMethod() != null;
        }
        return locationInParent == SingleVariableDeclaration.INITIALIZER_PROPERTY || locationInParent == VariableDeclarationFragment.INITIALIZER_PROPERTY || locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY || locationInParent == ArrayInitializer.EXPRESSIONS_PROPERTY || locationInParent == MethodInvocation.ARGUMENTS_PROPERTY || locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY || locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY || locationInParent == EnumConstantDeclaration.ARGUMENTS_PROPERTY || locationInParent == LambdaExpression.BODY_PROPERTY || locationInParent == ConditionalExpression.THEN_EXPRESSION_PROPERTY || locationInParent == ConditionalExpression.ELSE_EXPRESSION_PROPERTY || locationInParent == CastExpression.EXPRESSION_PROPERTY;
    }

    private static class AbortSearchException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AbortSearchException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CreateAnonymousClassCreationOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final List<LambdaExpression> fExpressions;

        public CreateAnonymousClassCreationOperation(List<LambdaExpression> changedNodes) {
            this.fExpressions = changedNodes;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = rewrite.getAST();
            for (LambdaExpression lambdaExpression : this.fExpressions) {
                Block block;
                TextEditGroup group = this.createTextEditGroup(FixMessages.LambdaExpressionsFix_convert_to_anonymous_class_creation, cuRewrite);
                ITypeBinding lambdaTypeBinding = lambdaExpression.resolveTypeBinding();
                IMethodBinding methodBinding = lambdaTypeBinding.getFunctionalInterfaceMethod();
                List parameters = lambdaExpression.parameters();
                String[] parameterNames = new String[parameters.size()];
                int i = 0;
                while (i < parameterNames.length) {
                    parameterNames[i] = ((VariableDeclaration)parameters.get(i)).getName().getIdentifier();
                    ++i;
                }
                CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cuRewrite.getCu().getJavaProject());
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext((ASTNode)lambdaExpression, importRewrite);
                MethodDeclaration methodDeclaration = StubUtility2.createImplementationStub(cuRewrite.getCu(), rewrite, importRewrite, importContext, methodBinding, parameterNames, lambdaTypeBinding.getName(), settings, false);
                ASTNode lambdaBody = lambdaExpression.getBody();
                if (lambdaBody instanceof Block) {
                    block = (Block)rewrite.createCopyTarget(lambdaBody);
                } else {
                    block = ast.newBlock();
                    List statements = block.statements();
                    ITypeBinding returnType = methodBinding.getReturnType();
                    Expression copyTarget = (Expression)rewrite.createCopyTarget(lambdaBody);
                    if (Bindings.isVoidType(returnType)) {
                        ExpressionStatement newExpressionStatement = ast.newExpressionStatement(copyTarget);
                        statements.add(newExpressionStatement);
                    } else {
                        ReturnStatement returnStatement = ast.newReturnStatement();
                        returnStatement.setExpression(copyTarget);
                        statements.add(returnStatement);
                    }
                }
                methodDeclaration.setBody(block);
                AnonymousClassDeclaration anonymousClassDeclaration = ast.newAnonymousClassDeclaration();
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                bodyDeclarations.add(methodDeclaration);
                Type creationType = ASTNodeFactory.newCreationType(ast, lambdaTypeBinding, importRewrite, importContext);
                ClassInstanceCreation classInstanceCreation = ast.newClassInstanceCreation();
                classInstanceCreation.setType(creationType);
                classInstanceCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
                rewrite.replace((ASTNode)lambdaExpression, (ASTNode)classInstanceCreation, group);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CreateLambdaOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private final List<ClassInstanceCreation> fExpressions;

        public CreateLambdaOperation(List<ClassInstanceCreation> expressions) {
            this.fExpressions = expressions;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRemover importRemover = cuRewrite.getImportRemover();
            AST ast = rewrite.getAST();
            for (ClassInstanceCreation classInstanceCreation : this.fExpressions) {
                TextEditGroup group = this.createTextEditGroup(FixMessages.LambdaExpressionsFix_convert_to_lambda_expression, cuRewrite);
                AnonymousClassDeclaration anonymTypeDecl = classInstanceCreation.getAnonymousClassDeclaration();
                List bodyDeclarations = anonymTypeDecl.bodyDeclarations();
                Object object = bodyDeclarations.get(0);
                if (!(object instanceof MethodDeclaration)) continue;
                MethodDeclaration methodDeclaration = (MethodDeclaration)object;
                List methodParameters = methodDeclaration.parameters();
                LambdaExpression lambdaExpression = ast.newLambdaExpression();
                List lambdaParameters = lambdaExpression.parameters();
                lambdaExpression.setParentheses(methodParameters.size() != 1);
                for (SingleVariableDeclaration methodParameter : methodParameters) {
                    VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
                    lambdaParameter.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodParameter.getName()));
                    lambdaParameters.add(lambdaParameter);
                }
                Block body = methodDeclaration.getBody();
                List statements = body.statements();
                Block lambdaBody = body;
                if (statements.size() == 1) {
                    Expression returnExpression;
                    Statement statement = (Statement)statements.get(0);
                    if (statement instanceof ExpressionStatement) {
                        lambdaBody = ((ExpressionStatement)statement).getExpression();
                    } else if (statement instanceof ReturnStatement && (returnExpression = ((ReturnStatement)statement).getExpression()) != null) {
                        lambdaBody = returnExpression;
                    }
                }
                lambdaExpression.setBody(rewrite.createCopyTarget((ASTNode)lambdaBody));
                rewrite.replace((ASTNode)classInstanceCreation, (ASTNode)lambdaExpression, group);
                importRemover.registerRemovedNode((ASTNode)classInstanceCreation);
                importRemover.registerRetainedNode((ASTNode)lambdaBody);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionalAnonymousClassesFinder
    extends ASTVisitor {
        private final ArrayList<ClassInstanceCreation> fNodes = new ArrayList();

        private FunctionalAnonymousClassesFinder() {
        }

        public static ArrayList<ClassInstanceCreation> perform(ASTNode node) {
            FunctionalAnonymousClassesFinder finder = new FunctionalAnonymousClassesFinder();
            node.accept((ASTVisitor)finder);
            return finder.fNodes;
        }

        public boolean visit(ClassInstanceCreation node) {
            if (LambdaExpressionsFix.isFunctionalAnonymous(node)) {
                this.fNodes.add(node);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LambdaExpressionsFinder
    extends ASTVisitor {
        private final ArrayList<LambdaExpression> fNodes = new ArrayList();

        private LambdaExpressionsFinder() {
        }

        public static ArrayList<LambdaExpression> perform(ASTNode node) {
            LambdaExpressionsFinder finder = new LambdaExpressionsFinder();
            node.accept((ASTVisitor)finder);
            return finder.fNodes;
        }

        public boolean visit(LambdaExpression node) {
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.getFunctionalInterfaceMethod() != null) {
                this.fNodes.add(node);
            }
            return true;
        }
    }

    private static final class SuperThisReferenceFinder
    extends HierarchicalASTVisitor {
        private ITypeBinding fFunctionalInterface;
        private MethodDeclaration fMethodDeclaration;

        private SuperThisReferenceFinder() {
        }

        static boolean hasReference(MethodDeclaration node) {
            try {
                SuperThisReferenceFinder finder = new SuperThisReferenceFinder();
                ClassInstanceCreation cic = (ClassInstanceCreation)node.getParent().getParent();
                finder.fFunctionalInterface = cic.getType().resolveBinding();
                finder.fMethodDeclaration = node;
                node.accept((ASTVisitor)finder);
            }
            catch (AbortSearchException abortSearchException) {
                return true;
            }
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(BodyDeclaration node) {
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            return node == this.fMethodDeclaration;
        }

        public boolean visit(ThisExpression node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            if (node.getQualifier() == null) {
                throw new AbortSearchException();
            }
            IBinding qualifierType = node.getQualifier().resolveBinding();
            if (qualifierType instanceof ITypeBinding && ((ITypeBinding)qualifierType).isInterface()) {
                throw new AbortSearchException();
            }
            return true;
        }

        public boolean visit(SuperFieldAccess node) {
            throw new AbortSearchException();
        }

        public boolean visit(MethodInvocation node) {
            IMethodBinding binding = node.resolveMethodBinding();
            if (binding != null && !JdtFlags.isStatic(binding) && node.getExpression() == null && Bindings.isSuperType(binding.getDeclaringClass(), this.fFunctionalInterface, false)) {
                throw new AbortSearchException();
            }
            return true;
        }
    }
}

